// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#ifndef	suck_h
#define	suck_h

static const char suck_h_rcsid[]="$Id: suck.h,v 1.6 1997/03/28 16:49:11 mrsam Exp $";

#include	"afx.h"
#include	"afxtempl.h"

#include	"asocket.h"
#include	<fstream.h>

#define	SOFT_ERROR if (!optQuiet || isatty(2))

class CSuck {
	int     sockfs;
	CASocket asyncbuf;

	CString line;

	int read_line()
	{
	int	s=80;
	LPSTR	p=line.GetBuffer(s);
	int	i=0;
	int	ch;

		while ((ch=asyncbuf.get()) != '\n' && ch != EOF)
		{
			if (i >= s)
			{
				line.ReleaseBuffer(i);
				p=line.GetBuffer(s += 80);
			}
			p[i++]=ch;
		}
		line.ReleaseBuffer(i);
		if (ch == EOF)
		{
			sockioerr();
			return (-1);
		}
		return (0);
	}

	void sockioerr()
	{
		if (asyncbuf.IsTimeout())
		{
		SOFT_ERROR 
			cerr << "Timed out waiting for POP3 server.\n";
		}
		else
		{
		SOFT_ERROR
			cerr << "POP3 server shut down connection.\n";
		}
	}

	int get_ok_err();
	int get_multiline();

	CUIntArray get_messages;
	CUIntArray del_messages;
	CStringArray uidl;

	int FigureOutWhatToDo(long);
	int OlderMethod();
	int UidlMethod();
	int SuckMessage(long, LPCTSTR mailer, LPCTSTR mailbox);
	fstream uidlfs;
	int lockfs;

	int command(CString cmd, BOOL doEcho=TRUE);
	int command(CString cmd, CString arg, BOOL doEcho=TRUE)
	{
		return (command(cmd+arg, doEcho));
	}

	int command(CString cmd, long arg, BOOL doEcho=TRUE)
	{
	char	buf[40];

		sprintf(buf, "%ld", arg);
		return (command(cmd, (CString)buf, doEcho));
	}
public:
	CSuck() : sockfs(-1), lockfs(-1) {}

static int optKeep, optDelKeep, optOlderOk, optDelKept, optQuiet, optVerbose,
	optTimeout, optEscapeDots;

	int Suck(LPCTSTR server, LPCTSTR user, LPCTSTR pwd, const CString &mailer,
			LPCTSTR mailbox, const CString &uidl);
	~CSuck();
} ;
#endif
