// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#ifndef	sigtrap_h
#define	sigtrap_h

static const char sigtrap_h_rcsid[]="$Id: sigtrap.h,v 1.1 1996/10/23 01:02:39 mrsam Exp $";

////////////////////////////////////////////////////////
//
//  The SigTrap class is used to trap SIGTERM, SIGINT
//  and SIGHUP signals during critical code section,
//  then check if these signals have occured when
//  disabled

class SigTrap {
	void (*old_sigint)(int);
	void (*old_sigterm)(int);
	void (*old_sighup)(int);

static	int  sigflag;
static	void sigtrap(int);

public:
	SigTrap();
	operator int();
	~SigTrap() { operator int(); }	// Make sure sig handlers are restored
} ;
#endif
