// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#include	"sigtrap.h"
#include	<signal.h>

static const char rcsid[]="$Id: sigtrap.C,v 1.1 1996/10/23 01:02:39 mrsam Exp $";

int SigTrap::sigflag;

SigTrap::SigTrap()
{
	sigflag=0;
	old_sigint=signal(SIGINT, sigtrap);
	old_sigterm=signal(SIGTERM, sigtrap);
	old_sighup=signal(SIGHUP, sigtrap);
}

void SigTrap::sigtrap(int)
{
	sigflag=1;
}

SigTrap::operator int()
{
	if (old_sigint != SIG_ERR)
		signal(SIGINT, old_sigint);
	old_sigint=SIG_ERR;
	if (old_sigterm != SIG_ERR)
		signal(SIGTERM, old_sigterm);
	old_sigterm=SIG_ERR;
	if (old_sighup != SIG_ERR)
		signal(SIGHUP, old_sighup);
	old_sighup=SIG_ERR;
	return (sigflag);
}
