// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#ifndef	debug_h
#define	debug_h

static const char debug_h_rcs_id[]="$Id: debug.h,v 1.1 1996/10/18 01:37:53 mrsam Exp $";

#ifdef	DEBUG

extern int debug_level;

#define	TRACE(level, fmt)	TRACE2((level), __LINE__, __FILE__, fmt)

#define	TRACE2(level, line, file, fmt)	\
	if ((level) < debug_level)	\
	{				\
		cerr << file << "(" << line << "): " << fmt;	\
	}

class DebugFunction {
	char *funcname;
public:
	DebugFunction(char *p) : funcname(p)
	{
		if (0 < debug_level)
			cerr << "*** Entering function " << funcname << "***\n";
	}

	~DebugFunction()
	{
		if (0 < debug_level)
			cerr << "*** Exiting function " << funcname << "***\n";
	}
} ;

#define	TRACE_FUNCTION(p)	DebugFunction debug_function(p);

#else

#define	TRACE(level,fmt)
#define	TRACE_FUNCTION(p)

#endif
#endif
