// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#ifndef	config_h
#define	config_h

#include	<fstream.h>
#include	"afx.h"
#include	"afxtempl.h"

static const char config_h_rcsid[]="$Id: config.h,v 1.5 1997/03/28 16:49:11 mrsam Exp $";

// Some compiled in constants

#ifdef	DEBUG
#define	VERSION "getpop3 1.08(DEBUG)"
#else
#define	VERSION	"getpop3 1.08"
#endif

#define	DEFAULT_CONFIG		"/etc/getpop3rc"
#define	DEFAULT_SENDMAIL	"/usr/bin/sendmail"
#define	DEFAULT_UIDL		"/var/spool/uidl"

/////////////////////////////////////////////////////
//
// The Config class offers basic configuration file
// processing - removal of comments and leading/trailing spaces

class Config {
	ifstream fs;
public:
	Config() {}
	~Config() {}
	int Open(const char *ininame);

	int operator>>(CStringArray &configrow);

	void Close() { if (fs.is_open())	fs.close(); }
} ;

#endif
