// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#include	"config.h"
#include	<ctype.h>

static const char rcsid[]="$Id: config.C,v 1.2 1996/10/23 01:02:39 mrsam Exp $";

int Config::Open(const char *ininame)
{
	fs.open(ininame);
	if (fs.bad())
		return (-1);
	return (0);
}

int Config::operator>>(CStringArray &opts)
{
CString buf;

	if (fs.bad() || fs.eof())
		return (-1);
	if (buf << fs)
		return (-1);

int	i=buf.Find('#');

	if (i >= 0)
	{
		buf.GetBuffer();
		buf.ReleaseBuffer(i);
	}

LPCTSTR p=buf;
int pass;
int cnt=0;

	for (pass=0; pass<2; pass++)
	{
		if (pass)
			opts.SetSize(cnt);
		cnt=0;

	int i;
		for (i=0; p[i]; )
		{
			if (isspace(p[i]))
			{
				i++;
				continue;
			}
		int j=i;

			while (p[j] && !isspace(p[j]))
				j++;

			if (pass)
			{
				opts[cnt]=buf.Mid(i, j-i);
				if (_tcscmp(opts[cnt], _T("*")) == 0)
					opts[cnt]=_T("");
			}
			i=j;
			++cnt;
			p=buf;
		}
	}
	return (0);
}

