// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#ifndef	asocket_h
#define	asocket_h

#include	"afx.h"
#include	"afxtempl.h"

static const char asocket_rcsid[]="$Id: asocket.h,v 1.2 1996/10/23 01:02:39 mrsam Exp $";

////////////////////////////////////////////////////////////
//
//  Asynchronous socket class
//
//  This class lets me handle input/output from a socket with
//  timeout.
//
//  This class does NOT keep the socket.  You will call
//  manage() function, and I will set the socket to
//  non-blocking mode, but that's about it.

#define	CASOCKET_DEFAULT_BUFFER_SIZE	512
#define CASOCKET_DEFAULT_TIMEOUT	300

class CASocket {
	int *sockfd;
	CArray<BYTE, BYTE> read_buffer;

	int read_ptr, read_cnt;

	int timeout;
	BOOL istimeout;

public:
	CASocket() : sockfd(NULL), read_ptr(0), read_cnt(0)	{}
	int manage(int &socket, int timeout=CASOCKET_DEFAULT_TIMEOUT,
			int buffer_size=CASOCKET_DEFAULT_BUFFER_SIZE);

	BOOL	IsTimeout() { return (istimeout); }
			// Did we return EOF from peekc/getc because of a
			// timeout?

	int	waitForRead();
	int	peek();
	int	get()
		{
		int c=peek();

			if (c != EOF)	++read_ptr;
		}
	int	write(const void *, size_t);
} ;
#endif
