// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#include	"afx.h"
#include	"asocket.h"
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include	<fcntl.h>

int CASocket::manage(int &socket, int timeoutVal, int buffer_size)
{
	sockfd= &socket;
	read_buffer.SetSize(buffer_size);
	read_ptr=read_cnt=0;
	timeout=timeoutVal;

int flags=fcntl(*sockfd, F_GETFL, 0);

	if (flags == -1)
		return (-1);

	if (fcntl(*sockfd, F_SETFL, flags | O_NDELAY) == -1)
		return (-1);
	return (0);
}

int CASocket::waitForRead()
{
	if (sockfd && *sockfd >= 0 && read_cnt >= 0)
	{
	fd_set	readset;
	struct timeval tv;

		FD_ZERO(&readset);
		FD_SET( *sockfd, &readset);
		tv.tv_sec=timeout;
		tv.tv_usec=0;

		if (select( (*sockfd) + 1, &readset, NULL, NULL, &tv) < 0)
			return (EOF);
		if (!FD_ISSET(*sockfd, &readset))
		{
			istimeout=TRUE;
			return (EOF);
		}
		return (0);
	}
	return (EOF);
}
int CASocket::peek()
{
	istimeout=FALSE;

	if (read_ptr < read_cnt)
		return ((unsigned char)read_buffer[read_ptr]);

	if (sockfd && *sockfd >= 0 && read_cnt >= 0)
	{
		if (waitForRead())
		{
			istimeout=TRUE;
			return (EOF);
		}

		read_cnt=read(*sockfd, read_buffer.GetData(),
			read_buffer.GetSize());
		if (read_cnt == 0)
			read_cnt= -1;
	}
	else
		read_cnt= -1;

	if (read_cnt < 0)
	{
		read_ptr=read_cnt;
		return (EOF);
	}
	read_ptr=0;
	return ((unsigned char)read_buffer[0]);
}

int	CASocket::write(const void *data, size_t dsize)
{
const char *p=(const char *)data;

	while (dsize)
	{
	fd_set	writeset;
	struct timeval tv;

		FD_ZERO(&writeset);
		FD_SET( *sockfd, &writeset);
		tv.tv_sec=timeout;
		tv.tv_usec=0;

		if (select( (*sockfd) + 1, NULL, &writeset, NULL, &tv) < 0)
			return (-1);

		if (!FD_ISSET(*sockfd, &writeset))
			return (-1);

	int	cnt= ::write( *sockfd, p, dsize);

		if (cnt < 0)	return (-1);
		p += cnt;
		dsize -= cnt;
	}
	return (0);
}
