// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#include	"ask.h"
#include	"debug.h"
#include	<termios.h>
#include	<iostream.h>
#include	<unistd.h>

static const char rcsid[]="$Id: ask.C,v 1.2 1996/10/19 04:49:25 mrsam Exp $";

int CAsk::Prompt(LPCTSTR strPrompt, BOOL disableEcho)
{
struct termios ts;

	if (!isatty(0))
	{
		TRACE(1, "Input not from terminal.\n");
		return (FALSE);
	}

	if (disableEcho)
	{
		tcgetattr(0, &ts);
		ts.c_lflag &= ~ECHO;
		tcsetattr(0, 0, &ts);
	}
	cout << strPrompt;
	(*this) << cin;

	if (disableEcho)
	{
		cout << "\n";
		ts.c_lflag |= ECHO;
		tcsetattr(0, 0, &ts);
	}
	return (TRUE);
}
