// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#include	"afx.h"
#include	"afxtempl.h"

#include	<iostream.h>
#include	<memory.h>
#include	<ctype.h>

// $Id: string2.C,v 1.3 1996/12/25 21:12:13 mrsam Exp $

// This string is a filename/pathname.  If string is too long for our needs
// shorten it a bit, and replace cut out stuff with "..."

#define	ELLIPSIS	_T("...")

CString CString::FileTitleTruncate(size_t maxLength)
{
int	l=GetLength();

	if (l <= maxLength)	return (*this);	// Not necessary

CString	buf= ELLIPSIS;

	if (l && *(LPCTSTR)*this == '/')
		buf= _T("/") ELLIPSIS;

	if (buf.GetLength() >= maxLength)
		return (buf.Left(maxLength));	// Cutting it a wee bit much

int	left=maxLength-buf.GetLength();

CString	temp_buf=Right(left);

	l=temp_buf.Find('/');
	if (l < 0)	l=0;

	return (buf + temp_buf.Mid(l));
}

CStringArray CStringTok(CString string, CString sep, BOOL smart=FALSE)
{
CStringList tokens;
int	inquotes=0;
int	prevtoken=0;
LPCSTR	strptr=string;
size_t	strleft=string.GetLength();
CString	buf;

	while (strleft)
	{
	int	ischar=TRUE;

		if (!inquotes)
		{
		LPCSTR sep_ptr=sep;
		size_t sep_cnt=sep.GetLength();

			while (sep_cnt)
			{
				if (*sep_ptr == *strptr)
					break;
				--sep_cnt;
				++sep_ptr;
			}
			if (sep_cnt)	ischar=FALSE;
		}

		if (ischar && !prevtoken)
			buf=_T("");
		if (!ischar && prevtoken)
			tokens.AddTail(buf);
		if (ischar)
		{
			if (smart && *strptr == '\\' && strleft > 1)
				++strptr, --strleft;
			else if (smart && *strptr == '"')
			{
				inquotes= !inquotes;
				++strptr; -- strleft;
				continue;
			}
			buf += *strptr;
		}
		prevtoken=ischar;
		++strptr;
		--strleft;
	}
	if (prevtoken)
		tokens.AddTail(buf);	// Last token

CStringArray array;

	array.SetSize(tokens.GetCount());

size_t	i=0;
POSITION p=tokens.GetHeadPosition();

	while (p)
		array[i++]=tokens.GetNext(p);
	return (array);
}

CStringArray CStringSplit(CString s, TCHAR fld)
{
CStringArray a;
size_t	i, j, k, n;

	j=s.GetLength();
	n=1;
	for (i=0; i<j; i++)
		if (s[i] == fld)	++n;

	a.SetSize(n);
	n=0;
	k=0;
	for (i=0; i<j; i++)
		if (s[i] == fld)
		{
			a[n++]=s.Mid(k, i-k);
			k=i+1;
		}
	a[n]=s.Mid(k);
	return (a);
}

CString CStringPaste(CStringArray a, TCHAR fld)
{
CString	s;
size_t	i, n;

	n=a.GetSize();
	for (i=0; i<n; i++)
	{
		if (i)	s += fld;
		s += a[i];
	}
	return (s);
}
