// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#include	<string.h>
#include	<stdio.h>
#include	<unistd.h>
#include	"afx.h"

static const char rcsid[]="$Id: exception.C,v 1.1 1996/10/31 02:11:51 mrsam Exp $";

// Various exception classes

LPCTSTR CException::GetErrorMessage()
{
	return ("ERROR: Program exception.");
}

int CException::GetErrorNumber()
{
	return (0);
}

void CException::ReportError()
{
LPCTSTR p=GetErrorMessage();

	write(2, p, _tcslen(p)*sizeof(*p));
}

static CSimpleException out_of_memory("ERROR: Out of memory.");
static CSimpleException internal("ERROR: Internal error detected.");

void AfxThrowMemoryException()
{
	throw &out_of_memory;
}

void AfxThrowInternalException()
{
	throw &internal;
}

