// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996, Double Precision, Inc.
// 
// THE SOFTWARE IS PROVIDED FREE OF CHARGE, "AS IS", WITHOUT WARRANTY OF ANY
// KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
// EVENT SHALL DOUBLE PRECISION, INC BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, ARISING FROM, OUT OF, OR IN CONNECTION WITH, OR USE OF THIS
// SOFTWARE.
// 
// Permission is granted to copy and distribute this software provided:
// 
//   1. The original getpop3 *.tgz is distributed by itself, or as a component
//      of another distribution, without any modifications, or changes.
//      You may not charge for copying or distributing the original, unaltered,
//      program, except for a nominal fee to cover duplication costs only.
// 
//   2. If you distribute a modified version of getpop3 by itself, or as a
//      component of another distribution, you must clearly identify your
//      changes or alterations, and acknowledge that you are responsible for
//      supporting any changes, and, identify the author of the original version
//      of this product.
// 
// Please see the included documentation for further information.
// 
// DEND
#ifndef	afx_h
#define	afx_h

#include	<iostream.h>
#include	<string.h>

// Obviously, I'm a transplanted developer :-)

static const char afx_h_rcs_id[]="$Id: afx.h,v 1.9 1997/03/25 04:33:48 mrsam Exp $";

typedef char TCHAR;
typedef TCHAR *LPSTR;
typedef const TCHAR *LPCSTR;
typedef LPSTR LPTSTR;
typedef LPCSTR LPCTSTR;
typedef unsigned char BYTE;
typedef short BOOL;
typedef void *LPVOID;
typedef const void *LPCVOID;
#ifndef	TRUE
#define	TRUE	-1
#endif
#ifndef	FALSE
#define	FALSE	0
#endif
#define	_tcslen	strlen
#define	_tcscmp	strcmp
#define	_tcsicmp	strcasecmp
#define	_tcsnicmp	strncasecmp
#define	_tcsncmp	strncmp
#define	_tcschr		strchr
#define	_T(s)	s
#define _tcsinc(p)	((p)+1)

// CString - a dynamic string with a fast copy operation.

struct CStrBuf {
	int refcnt;
	int len;	// How many characters in the string
	int size;	// Size of the allocated buffer

	// Strings begin here
	// Total size= sizeof(CStrBuf) + sizeof(TCHAR)*size
	} ;

class CString
{
	struct CStrBuf *buf;
public:
	// Ways we can construct ourselves
	CString() : buf(NULL) {}
	CString(const CString &o) : buf(o.buf) {
			if (buf)
			{
				++buf->refcnt;
			}
		}
	CString(LPCSTR);
	CString(LPCSTR, int);
	CString(TCHAR ch, int=1);

	int GetLength() const		// Character count, excluding \0
	{
		return (buf ? buf->len:0);
	}

	// Pretend we're a string

	TCHAR operator[](int) const;
	TCHAR &operator[](int);

	operator LPCTSTR() const		// as a C string
		{
			return (buf ? ptr():(LPCTSTR)NULL);
		}

	// Assign something to me

	const CString& operator=(const CString &o)
		{
			unlink();
			buf=o.buf;
			if (buf)
			{
				++buf->refcnt;
			}
			return *this;
		}

	const CString& operator=(LPCSTR str)
		{
			init (0, str);
			return(*this);
		}
	const CString& operator=(TCHAR ch)
		{
			init (1);
			ptr()[0]=ch;
			ptr()[1]=0;
			return (*this);
		}

	// Append something to me

	const CString& operator+=(const CString &);
	const CString& operator+=(LPCTSTR);
	const CString& operator+=(TCHAR);

	// Add two strings together
	// Since we'd like to add things in any order, let's
	// be consistent and use friend functions.

	friend CString operator+(const CString &, const CString &);
	friend CString operator+(const CString &, TCHAR);
	friend CString operator+(const CString &, LPCTSTR);
	friend CString operator+(TCHAR, const CString &);
	friend CString operator+(LPCTSTR, const CString &);

	// Compare me

	int Compare(const CString &b) const
		{
			return (_tcscmp( ptr(), b.ptr() ));
		}
	int Compare(LPCTSTR b) const
		{
			return (b ? _tcscmp( ptr(), b ): ptr() == NULL);
		}
	int CompareNoCase(const CString & b) const
		{
			return (_tcsicmp( ptr(), b.ptr() ));
		}
	int CompareNoCase(LPCTSTR b) const
		{
			return (b ? _tcsicmp( ptr(), b ) : ptr() == NULL);
		}

	// Chop me up
	CString Mid(int, int=-1) const;
	CString Left(int) const;
	CString Right(int) const;

	// Trim me
	void TrimRight();
	void TrimLeft();

	// Search me
	int Find(TCHAR) const;		// strchr
	int ReverseFind(TCHAR) const;	// strrchr

	// Advanced access
	LPTSTR GetBuffer(int=0);
	void ReleaseBuffer(int=-1);
	LPTSTR GetBufferSetLength(int);

	~CString() { unlink(); }

	void MakeUpper(), MakeLower();

// Extras!

	int operator<<(istream &);
	CString FileTitleTruncate(size_t);
	void Chop()
		{
		int l=GetLength();

			if (l > 0)
			{
				(void)GetBuffer(l-1);
				ReleaseBuffer(l-1);
			}
		}
private:
	LPTSTR ptr() const { return (buf ? (LPTSTR)(buf+1):(LPTSTR)NULL); }
	void init(int, LPCTSTR=NULL, int cnt= -1);
	void unlink() {
			if (buf && ! --buf->refcnt)
			{
				delete buf;
				buf=NULL;
			}
		      }
};

// Comparison macros

inline int operator==(const CString& a, const CString& b)
{
	return (a.Compare(b) == 0);
}

inline int operator!=(const CString &a, const CString &b)
{
	return ! (a == b);
}

inline int operator<(const CString &a, const CString &b)
{
	return (a.Compare(b) < 0);
}

inline int operator>(const CString &a, const CString &b)
{
	return (a.Compare(b) > 0);
}

inline int operator>=(const CString &a, const CString &b)
{
	return ! (a < b);
}

inline int operator<=(const CString &a, const CString &b)
{
	return ! (a > b);
}

inline int operator==(const CString& a, LPCTSTR b)
{
	return (b ? _tcscmp(a,b) == 0:(LPCTSTR)a == NULL);
}

inline int operator!=(const CString &a, LPCTSTR b)
{
	return ! (a == b);
}

inline int operator<(const CString &a, LPCTSTR b)
{
	return (_tcscmp(a, b) < 0);
}

inline int operator>(const CString &a, LPCTSTR b)
{
	return (_tcscmp(a, b) > 0);
}

inline int operator<=(const CString &a, LPCTSTR b)
{
	return ! (a > b);
}

inline int operator>=(const CString &a, LPCTSTR b)
{
	return ! (a < b);
}

inline int operator==(LPCTSTR a, const CString &b)
{
	return (a ? _tcscmp(a,b) == 0 : NULL == (LPCTSTR)b);
}

inline int operator!=(LPCTSTR a, const CString &b)
{
	return ! (a == b);
}

inline int operator<(LPCTSTR a, const CString &b)
{
	return (_tcscmp(a, b) < 0);
}

inline int operator>(LPCTSTR a, const CString &b)
{
	return (_tcscmp(a, b) > 0);
}

inline int operator<=(LPCTSTR a, const CString &b)
{
	return ! (a > b);
}

inline int operator>=(LPCTSTR a, const CString &b)
{
	return ! (a < b);
}

// A minimally usefull exception class

class CException {
public:
	BOOL m_autoDelete;
private:
	BOOL m_deleting;
public:
	CException(): m_autoDelete(TRUE), m_deleting(FALSE) {}
	CException(BOOL flag) : m_autoDelete(flag), m_deleting(FALSE) {}
	void Delete() { if (m_autoDelete && !m_deleting)
			{
				m_deleting=TRUE;
				delete this;
			}
		}
	virtual ~CException() {}
	virtual LPCTSTR GetErrorMessage();
	virtual int GetErrorNumber();
	virtual void ReportError();
} ;

class CSimpleException : public CException {
        LPCTSTR emsg;
public:
        CSimpleException(LPCTSTR p) : CException(FALSE), emsg(p) {}
        ~CSimpleException() {}

        LPCTSTR GetErrorMessage() { return (emsg); }
} ;
void AfxThrowMemoryException();
void AfxThrowInternalException();

/////////////////////////////////////////////////////////////////////
//
// On occasion, we need to call a constructor directly:

inline void *operator new (size_t, void *p) { return (p); }

#define	AFXCONSTRUCT(ptr,type)	new((ptr)) type
#define	AFXCOMMA	,		// To be used in AFXCONSTRUCT

#endif
