// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#ifndef	suck_h
#define	suck_h

static const char suck_h_rcsid[]="$Id: suck.h,v 1.9 1998/05/25 17:29:30 mrsam Exp $";

#include	"afx.h"
#include	"afxtempl.h"
#include	"asocket.h"
#include	<fstream.h>
#include	<pwd.h>
#include	<sys/types.h>

#define	SOFT_ERROR if (!optQuiet || isatty(2))

class CSuck {
	int     sockfs;
	CASocket asyncbuf;

	CString line;

	int	read_line();
	void sockioerr()
	{
		if (asyncbuf.IsTimeout())
		{
		SOFT_ERROR 
			cerr << "Timed out waiting for POP3 server.\n";
		}
		else
		{
		SOFT_ERROR
			cerr << "POP3 server shut down connection.\n";
		}
	}

	int get_ok_err();
	int get_multiline();

	CUIntArray get_messages;
	CUIntArray del_messages;
	CStringArray uidl;

	int FigureOutWhatToDo(long);
	int OlderMethod();
	int UidlMethod();
	int SuckMessage(long, LPCTSTR mailer, LPCTSTR mailbox);
	fstream uidlfs;
	int lockfs;

	int command(CString cmd, BOOL doEcho=TRUE);
	int command(CString cmd, CString arg, BOOL doEcho=TRUE)
	{
		return (command(cmd+arg, doEcho));
	}

	int command(CString cmd, long arg, BOOL doEcho=TRUE)
	{
	char	buf[40];

		sprintf(buf, "%ld", arg);
		return (command(cmd, (CString)buf, doEcho));
	}
public:
	CSuck() : sockfs(-1), lockfs(-1) {}

static int optKeep, optDelKeep, optOlderOk, optDelKept, optQuiet, optVerbose,
	optTimeout, optEscapeDots;

	int Suck(LPCTSTR server, LPCTSTR user, LPCTSTR pwd, const CString &mailer,
			LPCTSTR mailbox, const CString &uidl,
			uid_t uid, gid_t gid);
	~CSuck();
} ;
#endif
