// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#include	"afx.h"
#include	<iostream.h>
#include	<memory.h>
#include	<ctype.h>

static const char rcsid[]="$Id: string.C,v 1.2 1996/12/16 05:53:48 mrsam Exp $";

/////////////////////////////////////////////////////////////////////
//
// CString

CString::CString(LPCSTR str) : buf(NULL)
{
	init(0, str);
}

CString::CString(LPCSTR str, int cnt) : buf(NULL)
{
	init(cnt, str, cnt);
}

CString::CString(TCHAR ch, int len) : buf(NULL)
{
	init(len);

int i;
LPTSTR p=ptr();

	for (i=len; i; --i)
		*p++ = ch;
	*p=0;
}

void CString::init(int len, LPCTSTR p, int ncpy)
{
	if (p && ncpy < 0)
	{
		ncpy=_tcslen(p);
	}

	if (p && len <= ncpy)	len=ncpy;

	++len;	// Make sure we'll have space for terminating null.

	if (!buf || buf->refcnt > 1 || len > buf->size)
		// Must have our private copy in these situations
	{
	int size = sizeof(CStrBuf) + len*sizeof(TCHAR) + 32;

		size -= (size % 32);		// Allocate memory in blocks

	struct CStrBuf *newbuf = (struct CStrBuf *) new BYTE[size];

		if (!newbuf)	AfxThrowMemoryException();

	struct CStrBuf *oldp=buf;

		buf=newbuf;

		buf->refcnt=1;
		buf->size= (size - sizeof(CStrBuf))/sizeof(TCHAR);
		buf->len=len-1;

		if (p)
			memcpy( ptr(), p, ncpy * sizeof(TCHAR));
		else if (oldp)
		{
			if (oldp->len > buf->len)
				memcpy(ptr(), (LPCTSTR)(oldp+1),
					buf->len * sizeof(TCHAR));
			else
			{
				memcpy(ptr(), (LPCTSTR)(oldp+1),
					oldp->len * sizeof(TCHAR));
			}
		}
		if (oldp && ! --oldp->refcnt)
		{
			delete oldp;
		}
	}
	else
	{
		if (p)
			memcpy( ptr(), p, ncpy * sizeof(TCHAR));
		buf->len=len-1;
	}
	ptr()[buf->len]=0;	// Append terminating null
}
TCHAR CString::operator[](int n) const
{
	if (n >= GetLength())	AfxThrowInternalException();
	return (ptr()[n]);
}

TCHAR &CString::operator[](int n)
{
	if (n >= GetLength())	AfxThrowInternalException();
	init (buf->len);
	return (ptr()[n]);
}

const CString &CString::operator+=(const CString &o)
{
int	l=GetLength();
int	ol=o.GetLength();

	if (ol == 0)	return (*this);

	init(l+ol);
	memcpy(ptr()+l, o.ptr(), ol);
	ptr()[l+ol]=0;
	return (*this);
}

const CString &CString::operator+=(LPCTSTR s)
{
int	l=GetLength();
int	ol=_tcslen(s);

	if (ol == 0)	return (*this);

	init(l+ol);
	memcpy(ptr()+l, s, ol);
	ptr()[l+ol]=0;
	return (*this);
}

const CString &CString::operator+=(TCHAR c)
{
int	l=GetLength();

	init(l+1);
	ptr()[l]=c;
	ptr()[l+1]=0;
	return (*this);
}

// Friendly addition functions

CString operator+(const CString &a, const CString &b)
{
CString c;
int al=a.GetLength(), bl=b.GetLength();

	c.init(al+bl);
	if (al)
		memcpy(c.ptr(), a.ptr(), al * sizeof(TCHAR));
	if (bl)
		memcpy(c.ptr()+al, b.ptr(), bl * sizeof(TCHAR));
	c.ptr()[al+bl]=0;
	return (c);
}

CString operator+(const CString &a, TCHAR b)
{
CString c;
int al=a.GetLength();

	c.init(al+1);
	if (al)
		memcpy(c.ptr(), a.ptr(), al * sizeof(TCHAR));
	c.ptr()[al]=b;
	c.ptr()[al+1]=0;
	return (c);
}

CString operator+(const CString &a, LPCTSTR b)
{
CString c;
int al=a.GetLength(), bl=b ? _tcslen(b):0;

	c.init(al+bl);
	if (al)
		memcpy(c.ptr(), a.ptr(), al * sizeof(TCHAR));
	if (bl)
		memcpy(c.ptr()+al, b, bl * sizeof(TCHAR));
	c.ptr()[al+bl]=0;
	return (c);
}

CString operator+(TCHAR a, const CString &b)
{
CString c;
int bl=b.GetLength();

	c.init(bl+1);
	c.ptr()[0]=a;
	if (bl)
		memcpy(c.ptr()+1, b.ptr(), bl * sizeof(TCHAR));
	c.ptr()[bl+1]=0;
	return (c);
}

CString operator+(LPCTSTR a, const CString &b)
{
CString c;
int bl=b.GetLength(), al=a ? _tcslen(a):0;

	c.init(al+bl);
	if (al)
		memcpy(c.ptr(), a, al * sizeof(TCHAR));
	if (bl)
		memcpy(c.ptr()+al, b.ptr(), bl * sizeof(TCHAR));
	c.ptr()[al+bl]=0;
	return (c);
}

CString CString::Mid(int start, int len) const
{
CString rc;
int l=GetLength();

	if (start < l)
	{
		if (len < 0)	len= l-start;

		if (len > l-start)	len=l-start;
		rc.init(len, ptr()+start, len);
	}
	return (rc + "");	// Make sure we won't return a NULL
}

CString CString::Left(int cnt) const
{
int l=GetLength();

	if (cnt > l)	cnt=l;

CString	rc;

	rc.init(cnt, ptr(), cnt);
	return (rc);
}

CString CString::Right(int cnt) const
{
int l=GetLength();

	if (cnt > l)	cnt=l;

CString	rc;

	rc.init(cnt, ptr() + l-cnt, cnt);
	return (rc);
}

void CString::TrimLeft()
{
int l=GetLength();
int i;

	init(l);	// Make sure we have our own copy

LPTSTR p=ptr();

	for (i=0; i<l; i++)
		if (!isspace(p[i]))
			break;
	if (i)
	{
		if (l > i)
			memmove(ptr(), ptr()+i, l-i);
		buf->len -= i;
		ptr()[buf->len]=0;
	}
}

void CString::TrimRight()
{
int l=GetLength();

	init(l);	// Make sure we have our own copy

int i,j;
LPTSTR p=ptr();

	for (i=j=0; i<l; i++)
		if (!isspace(p[i]))
			j=i+1;
	buf->len=j;
	ptr()[j]=0;
}

int CString::Find(TCHAR c) const
{
int i,l=GetLength();
LPCTSTR p=ptr();

	for (i=0; i<l; i++)
		if (*p++ == c)
			return (i);
	return (-1);
}

int CString::ReverseFind(TCHAR c) const
{
int i,l=GetLength();
LPTSTR p=ptr()+l;

	for (i=l; i--; )
		if (*--p == c)
			return (i);
	return (-1);
}

LPTSTR CString::GetBuffer(int minsize)
{
int l=GetLength();

	if (minsize < l)	minsize=l;
	init(minsize);
	if (l < minsize)
	{
		memset( ptr()+l, 0, (minsize-l)*sizeof(TCHAR));
		ptr()[minsize]=0;
	}
	return ( ptr() );
}

void CString::ReleaseBuffer(int len)
{
	if (len < 0)	len=_tcslen(ptr());
	if (len >= buf->size)	len=buf->size-1;
	buf->len=len;
	ptr()[len]=0;
}

LPTSTR CString::GetBufferSetLength(int len)
{
int l=GetLength();

	if (len < l)
		init(len);
	return (GetBuffer(len));
}

int CString::operator<< (istream &i)
{
char lbuf[80];
int cnt;

	(*this)=_T("");

	while (i.get(lbuf, sizeof(lbuf)-1), cnt=i.gcount())
	{
		lbuf[cnt]=0;
		(*this) += lbuf;
	}
	return (i.get() == EOF && (*this).GetLength() == 0 ? EOF:0);
}

void CString::MakeUpper()
{
LPTSTR p=GetBuffer();

	while (*p)
	{
		*p=toupper(*p);
		p=_tcsinc(p);
	}
	ReleaseBuffer();
}

void CString::MakeLower()
{
LPTSTR p=GetBuffer();

	while (*p)
	{
		*p=tolower(*p);
		p=_tcsinc(p);
	}
}

