// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#ifndef	sigtrap_h
#define	sigtrap_h

static const char sigtrap_h_rcsid[]="$Id: sigtrap.h,v 1.2 1998/05/25 06:18:16 mrsam Exp $";


#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif

////////////////////////////////////////////////////////
//
//  The SigTrap class is used to trap SIGTERM, SIGINT
//  and SIGHUP signals during critical code section,
//  then check if these signals have occured when
//  disabled

class SigTrap {
	RETSIGTYPE (*old_sigint)(int);
	RETSIGTYPE (*old_sigterm)(int);
	RETSIGTYPE (*old_sighup)(int);

static	int  sigflag;
static	RETSIGTYPE sigtrap(int);

public:
	SigTrap();
	operator int();
	~SigTrap() { operator int(); }	// Make sure sig handlers are restored
} ;
#endif
