// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"sigtrap.h"
#include	<signal.h>

static const char rcsid[]="$Id: sigtrap.C,v 1.2 1998/05/25 06:18:16 mrsam Exp $";

int SigTrap::sigflag;

SigTrap::SigTrap()
{
	sigflag=0;
	old_sigint=signal(SIGINT, sigtrap);
	old_sigterm=signal(SIGTERM, sigtrap);
	old_sighup=signal(SIGHUP, sigtrap);
}

RETSIGTYPE SigTrap::sigtrap(int)
{
	sigflag=1;
#if RETSIGTYPE != void
	return 0;
#endif
}

SigTrap::operator int()
{
	if (old_sigint != SIG_ERR)
		signal(SIGINT, old_sigint);
	old_sigint=SIG_ERR;
	if (old_sigterm != SIG_ERR)
		signal(SIGTERM, old_sigterm);
	old_sigterm=SIG_ERR;
	if (old_sighup != SIG_ERR)
		signal(SIGHUP, old_sighup);
	old_sighup=SIG_ERR;
	return (sigflag);
}
