// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#include	"afx.h"
#if	HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	<iostream.h>
#include	<strstream.h>
#include	<memory.h>
#include	<ctype.h>
#include	<pwd.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<stdlib.h>
#include	<signal.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#if HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if HAVE_SYS_FILE_H
#include	<sys/file.h>
#endif
#if HAVE_SYS_STATFS_H
#include	<sys/statfs.h>
extern "C" int statfs(LPCTSTR,struct statfs*);
#endif
#include	<sys/stat.h>
#if HAVE_SYS_VFS_H
#include	<sys/vfs.h>
#endif
#if HAVE_SYSLOG_H
#include	<syslog.h>
#endif

#include	"debug.h"
#include	"config.h"
#include	"ask.h"
#include	"suck.h"
#include	"asocket.h"

#ifdef	DEBUG
int	debug_level=0;
#endif
int	log_open;

#define	BANNER	VERSION "  Copyright 1997 Double Precision, Inc.\n" \
		"See README.getpop3 for distribution and installation notes.\n"

static const char rcsid[]="$Id: main.C,v 1.17 1998/05/26 23:49:22 mrsam Exp $";
static const char *progname;

void usage()
{
TRACE_FUNCTION("Usage")

	cout << "Usage: " << progname <<
#ifdef	DEBUG
		" [-d level]"
#endif
			" [-a account] [-p password] [-h server] [-l lockfile]\n"
			"\t[-t #] [-V] [-k] [-K] [-o] [-D] [-u uidl] [-m mailer]\n"
			"\t[-D 0|1] [-s fsys:nblk, fsys:nblk ... ] [-v] [-q] [-A] userid\n"
		"\n"
#ifdef	DEBUG
		"\t-d level       Set debug level (0 - none)\n"
#endif
		"\t-V             Just show the program version.\n"
		"\t-u account     Account (userid) on the POP3 server\n"
		"\t-p password    Password to give to the POP3 server\n"
		"\t-h server      Name of the POP3 server\n"
                "\t-l file        Try to lock this file, if already locked,\n"
                "\t               exit gracefully.\n"
		"\t-A             Automatic mode.  Get mail for every user.\n"
		"\t-U uidl        Name of file to save UIDL data\n"
		"\t-k             Keep messages on the POP3 server, don't delete them\n"
		"\t               Also, doesn't download previously-kept messages.\n"
                "\t-K             Erase all record of kept messages (downloads them\n"
                "\t               again.\n"
                "\t-o             If the server doesn't support the UIDL command, use\n"
		"\t               older, alternate, less reliable method for\n"
		"\t               tracking messages already seen.\n"
                "\t-D             Delete messages kept on the server.\n"
		"\n"
		"\t-m mailer      Use this instead of sendmail to deliver mail.\n"
		"\t-v             Verbose mode.  I will trace POP3 dialogue even\n"
		"\t               if my output is not going to a terminal.\n"
		"\t-q             Quiet mode.  I will not complain about errors\n"
		"\t               that are probably caused by PPP being inactive,\n"
		"\t               I'll just terminate quietly.  I certainly WILL\n"
		"\t               complain about anything else.\n"
		"\t-Q             Do not log activity to syslog.\n"
		"\t-E 0           Do not escape dots when feeding message to mailer.\n"
		"\t-E 1           Double dots at the beginning of lines when feeding\n"
                "\t               message to mailer.  End message with a line containing\n"
		"\t               a single dot.\n"
		"\t-s fsys:#, ... Flame guard.  Do not run if filesystem has\n"
		"\t               fewer than # blocks free.\n"
		"\t-t #           Specify timeout interval, # is in seconds\n"
		"\t               (default " << CASOCKET_DEFAULT_TIMEOUT <<
							").\n"
		"\tuserid         Local user who gets the mail.\n"
		;
}

static int dosuck(const char *, const char *, const char *, const char *,
	const CString &, const CString &, uid_t, gid_t);

static int prepsuck(BOOL autoMode,
		const char *user, const char *acct, const char *pwd,
		const char *host, const CString &mailerStr, const CString &uidlStr)
{
TRACE_FUNCTION("prepsuck")
struct passwd *p;
int	rc=0;

	if (!autoMode)
		p=getpwnam(user);
	else
		p=getpwent();

BOOL	found=FALSE;

	for (;p; p=autoMode ? getpwent():0)
	{
	CString	config_filename;

		config_filename=p->pw_dir;
		config_filename += DEFAULT_CONFIGFILE;


	Config	cf;
	struct stat stat_buf;

		cf.Open(config_filename);
		if (cf.fs.bad() || cf.fs.eof())	continue;
		if (fstat(cf.fs.rdbuf()->fd(), &stat_buf)) continue;
		if (stat_buf.st_mode & 0077)
		{
			cerr << config_filename << " has group or world permissions, skipping." << endl;
			continue;
		}
		found=TRUE;
	CStringArray opts;

		while ((cf >> opts) == 0)
		{
			if (opts.GetSize() == 0)	continue;

			if (opts.GetSize() < 3)
			{
				cerr << "Bad user line in " << config_filename << "\n";
				break;
			}

			if (host)	opts[0]=host;
			if (acct)	opts[1]=acct;
			if (pwd)	opts[2]=pwd;

		CString	uidlPath;

			uidlPath=p->pw_dir;
			uidlPath += DEFAULT_UIDLFILE;

			if (opts.GetSize() >= 4)
			{
				uidlPath=opts[3];
				if (* (const char *)uidlPath != '/')
					uidlPath = (CString)p->pw_dir + "/" +
						uidlPath;
			}

		int	rc2=dosuck(p->pw_name, opts[1], opts[2], opts[0],
					mailerStr, uidlPath,
					p->pw_uid, p->pw_gid);

			if (rc2)	rc=10;
		}
	}
	if (!found && !autoMode)
	{
		p=getpwnam(user);
		if (!p)
		{
			cerr << "No such user." << endl;
			return (10);
		}
		return (dosuck(user, acct, pwd, host, mailerStr, uidlStr,
				p->pw_uid, p->pw_gid));
	}
	return (0);
}

static int dosuck(const char *user, const char *acct, const char *pwd,
		const char *host, const CString &mailerStr,
		const CString &uidlStr, uid_t uid, gid_t gid)
{
TRACE_FUNCTION("dosuck")

//	Try to read the rest of the information from the user.

CAsk	AskAcct;

	if (!acct || !*acct)
	{
		if (!AskAcct.Prompt((CString)user + "'s POP3 userid: "))
		{
			usage();
			return (10);
		}
		acct=AskAcct;
	}

	if (_tcslen(acct) == 0)
	{
		usage();
		return (10);
	}

CAsk	AskPwd;

	if (!pwd || !*pwd)
	{
		if (!AskPwd.Prompt((CString)user + "'s POP3 password: ", TRUE))
		{
			usage();
			return (10);
		}
		pwd=AskPwd;
	}

	if (_tcslen(pwd) == 0)
	{
		usage();
		return (10);
	}

CAsk	AskHost;

	if (!host || !*host)
	{
		if (!AskHost.Prompt((CString)user + "'s POP3 server: "))
		{
			usage();
			return (10);
		}
		host=AskHost;
	}

	if (_tcslen(host) == 0)
	{
		usage();
		return (10);
	}

	TRACE(1, "Local user: " << user << '\n')
	TRACE(1, "POP3 userid: " << acct << '\n')
	TRACE(1, "POP3 password: " << pwd << '\n')
	TRACE(1, "POP3 server: " << host << '\n')
	TRACE(1, "Mailer: " << mailerStr << '\n')
	TRACE(1, "UidlPath: " << uidlStr << '\n')
	return (CSuck().Suck(host, acct, pwd, mailerStr, user, uidlStr, uid, gid));
}

static int main2(int, char *[]);

int main(int argc, char *argv[])
{
int rc;

	progname=argv[0];
	log_open=FALSE;
	try
	{
		rc=main2(argc, argv);
	}
	catch (CException *ce)
	{
		ce->ReportError();
		ce->Delete();
		rc= 99;
	}
	if (log_open)
	{
#if HAVE_SYSLOG_H
		openlog(VERSION, LOG_PID, LOG_MAIL);
		syslog(LOG_INFO, "Terminated.");
#endif
	}
	return (rc);
}

//  New V1.0 - check for free space

static int check_free_space_sys(CString &);

static int check_free_space(CString &s)
{
TRACE_FUNCTION("check_free_space");
int i;

	while ((i=s.Find(',')) >= 0)
	{
	CString cfile=s.Left(i);

		s=s.Mid(i+1);
		if (check_free_space_sys(cfile))
			return (-1);
	}
	return (check_free_space_sys(s));
}

static long myatol(const char *p)
{
istrstream parse_num(p);
long n;

	parse_num >> n;
	return (n);
}
	
static int check_free_space_sys(CString &s)
{
TRACE_FUNCTION("check_free_space_sys");

long	nBlocks=2048;
int	i;

	if ((i=s.Find(':')) >= 0)
	{
	CString num_blocks_s=s.Mid(i+1);

		s=s.Left(i);

		nBlocks=myatol(num_blocks_s);
	}
	TRACE(2, "File system is " << s << ", # blocks is " << nBlocks << "\n");
	if (_tcscmp(s, "") == 0)
		return (0);

struct statfs sfs;
int	rc=statfs(s, &sfs);

	TRACE(2, "statfs() returned " << rc << "\n");
	if (rc)
	{
		cerr << "ERROR: " << s << " filesystem did not report available space." << endl;
		return (1);
	}

	TRACE(2, s << ": # of free blocks is " << sfs.f_bfree << endl);
	if (sfs.f_bfree >= nBlocks)
		return (0);

	if (isatty(2))
		cerr << "ERROR: " << s << " filesystem has only "
			<< sfs.f_bfree << " free blocks." << endl;
	return (1);
}

int main2(int argc, char *argv[])
{
int optc;
char *popacct=NULL, *pophost=NULL;
CString poppwd, popuser;
CString mailerStr=_T(DEFAULT_SENDMAIL);
CString uidlStr=_T(DEFAULT_UIDLFILE);
char	*lockfile=NULL;
BOOL	automode=FALSE;
CString	fscheck=_T("");
int	version=0;

	if (isatty(2))
		cerr << BANNER << "\n";

	signal(SIGPIPE, SIG_IGN);

	CSuck::optEscapeDots=DOTESCAPE;

	log_open=TRUE;
	while ((optc=getopt(argc, argv,
#ifdef	DEBUG
		"d:"
#endif
		"?m:U:u:p:h:kKoDl:qQvAs:Vt:E:"
			)) >= 0)
	{
		switch (optc)	{
		case '?':
			usage();
			return (0);
#ifdef	DEBUG
		case 'd':
			debug_level=atoi(optarg);
			break;
#endif
		case 'u':
			popacct=optarg;
			break;
		case 'E':
			CSuck::optEscapeDots=atoi(optarg);
			break;
		case 'p':
			poppwd=optarg;
			memset(argv[optind-1], ' ', strlen(argv[optind-1]));
			strcpy(argv[optind-1], "");
			break;
		case 'h':
			pophost=optarg;
			break;
		case 'm':
			mailerStr=optarg;
			break;
		case 'U':
			uidlStr=optarg;
			break;
		case 'k':
			CSuck::optKeep=1;
			break;
		case 'K':
			CSuck::optKeep=1;	// Save user from a bad mistake.
			CSuck::optDelKeep=1;
			break;
		case 'o':
			CSuck::optOlderOk=1;
			break;
		case 'D':
			CSuck::optDelKept=1;
			break;
		case 'l':
			lockfile=optarg;
			break;
		case 'q':
			CSuck::optQuiet=1;
			break;
		case 'Q':
			log_open=FALSE;
			break;
		case 'v':
			CSuck::optVerbose=1;
			break;
		case 't':
			CSuck::optTimeout=atoi(optarg);
			break;
		case 'A':
			if (getuid())
			{
				cerr << "You must be root to use the -A option.";
				return (10);
			}
			automode=1;
			break;
		case 's':
			fscheck=optarg;
			break;
		case 'V':
			version=1;
			break;
		default:
			usage();
			return (10);
		}
	}
	if (version)
	{
		return (0);	// We already printed the banner.
	}
	if (log_open)
	{
#if HAVE_SYSLOG_H
		openlog(VERSION, LOG_PID, LOG_MAIL);
		syslog(LOG_INFO, "Started.");
#endif
	}

	if (lockfile)
	{
	int	fd=open(lockfile, O_RDWR | O_CREAT, 0666);

		if (fd < 0)
		{
			cerr << "Can't open the lock file.\n";
			return (10);
		}
#if HAS_LOCKF
		if (lockf(fd, F_TLOCK, 0))
		{
			TRACE(1, "Lock file already locked.\n");
			return (0);
		}
#else
#if HAS_FLOCK
		if (flock(fd, LOCK_EX | LOCK_NB))
		{
			TRACE(1, "Lock file already locked.\n");
			return (0);
		}
#endif
#endif
	}
	if (check_free_space(fscheck))
		return (5);

	if (optind == argc)
	{
	struct passwd *p=getpwuid(getuid());

		if (!p)
		{
			cerr << "You don't have an entry in passwd!\n";
			return (10);
		}
		popuser=p->pw_name;
		if (automode)
		{
			if (popacct || poppwd || pophost)
			{
				cerr << "Can't specify -u -p -h with -A option.\n";
				return (10);
			}
		}
		return (prepsuck(automode,
			popuser, popacct, poppwd, pophost, mailerStr, uidlStr));
	}
	else if (automode)
	{
		cerr << "With -A option, you don't specify users!\n";
		return (10);
	}
	else if (argc - optind > 1)
	{
		if (popacct || poppwd || pophost)
		{
			cerr << "Can't specify -u -p -h with multiple users.\n";
			return (10);
		}

	int	i;

		for (i=optind; i<argc; i++)
		{
		int rc=prepsuck(FALSE,
			 argv[i], NULL, NULL, NULL, mailerStr, uidlStr);

			if (rc)	return (rc);
		}
	}
	else
	{
		return (prepsuck(FALSE, argv[optind],
			popacct, poppwd, pophost, mailerStr, uidlStr));
	}
	return (0);
}
