// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#ifndef	debug_h
#define	debug_h

static const char debug_h_rcs_id[]="$Id: debug.h,v 1.1 1996/10/18 01:37:53 mrsam Exp $";

#ifdef	DEBUG

extern int debug_level;

#define	TRACE(level, fmt)	TRACE2((level), __LINE__, __FILE__, fmt)

#define	TRACE2(level, line, file, fmt)	\
	if ((level) < debug_level)	\
	{				\
		cerr << file << "(" << line << "): " << fmt;	\
	}

class DebugFunction {
	char *funcname;
public:
	DebugFunction(char *p) : funcname(p)
	{
		if (0 < debug_level)
			cerr << "*** Entering function " << funcname << "***\n";
	}

	~DebugFunction()
	{
		if (0 < debug_level)
			cerr << "*** Exiting function " << funcname << "***\n";
	}
} ;

#define	TRACE_FUNCTION(p)	DebugFunction debug_function(p);

#else

#define	TRACE(level,fmt)
#define	TRACE_FUNCTION(p)

#endif
#endif
