// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#ifndef	asocket_h
#define	asocket_h

#include	"afx.h"
#include	"afxtempl.h"

static const char asocket_rcsid[]="$Id: asocket.h,v 1.3 1998/05/25 17:29:30 mrsam Exp $";

////////////////////////////////////////////////////////////
//
//  Asynchronous socket class
//
//  This class lets me handle input/output from a socket with
//  timeout.
//
//  This class does NOT keep the socket.  You will call
//  manage() function, and I will set the socket to
//  non-blocking mode, but that's about it.

#define	CASOCKET_DEFAULT_BUFFER_SIZE	512
#define CASOCKET_DEFAULT_TIMEOUT	300

class CASocket {
	int *sockfd;
	CArray<BYTE, BYTE> read_buffer;

	int read_ptr, read_cnt;

	int timeout;
	BOOL istimeout;

public:
	CASocket() : sockfd(NULL), read_ptr(0), read_cnt(0)	{}
	int manage(int &socket, int timeout=CASOCKET_DEFAULT_TIMEOUT,
			int buffer_size=CASOCKET_DEFAULT_BUFFER_SIZE);

	BOOL	IsTimeout() { return (istimeout); }
			// Did we return EOF from peekc/getc because of a
			// timeout?

	int	waitForRead();
	int	peek();
	int	get()
		{
		int c=peek();

			if (c != EOF)	++read_ptr;
			return (c);
		}
	int	write(const void *, size_t);
} ;
#endif
