// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#include	"afx.h"
#include	"debug.h"
#include	"asocket.h"
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<sys/types.h>
#if TIME_WITH_SYS_TIME
#include	<sys/time.h>
#include	<time.h>
#else
#if HAVE_SYS_TIME_H
#include	<sys/time.h>
#else
#include	<time.h>
#endif
#endif
#if HAVE_FCNTL_H
#include	<fcntl.h>
#endif

int CASocket::manage(int &socket, int timeoutVal, int buffer_size)
{
	sockfd= &socket;
	read_buffer.SetSize(buffer_size);
	read_ptr=read_cnt=0;
	timeout=timeoutVal;

int flags=fcntl(*sockfd, F_GETFL, 0);

	if (flags == -1)
		return (-1);

	if (fcntl(*sockfd, F_SETFL, flags | O_NDELAY) == -1)
		return (-1);
	return (0);
}

int CASocket::waitForRead()
{
	if (sockfd && *sockfd >= 0 && read_cnt >= 0)
	{
	fd_set	readset;
	struct timeval tv;

		FD_ZERO(&readset);
		FD_SET( *sockfd, &readset);
		tv.tv_sec=timeout;
		tv.tv_usec=0;

		if (select( (*sockfd) + 1, &readset, NULL, NULL, &tv) < 0)
			return (EOF);
		if (!FD_ISSET(*sockfd, &readset))
		{
			istimeout=TRUE;
			return (EOF);
		}
		return (0);
	}
	return (EOF);
}
int CASocket::peek()
{
	istimeout=FALSE;

	if (read_ptr < read_cnt)
		return ((unsigned char)read_buffer[read_ptr]);

	if (sockfd && *sockfd >= 0 && read_cnt >= 0)
	{
		if (waitForRead())
		{
			istimeout=TRUE;
			return (EOF);
		}

		read_cnt=read(*sockfd, read_buffer.GetData(),
			read_buffer.GetSize());
		if (read_cnt == 0)
			read_cnt= -1;
	}
	else
		read_cnt= -1;

	if (read_cnt < 0)
	{
		read_ptr=read_cnt;
		return (EOF);
	}
	read_ptr=0;
	return ((unsigned char)read_buffer[0]);
}

int	CASocket::write(const void *data, size_t dsize)
{
const char *p=(const char *)data;

	while (dsize)
	{
	fd_set	writeset;
	struct timeval tv;

		FD_ZERO(&writeset);
		FD_SET( *sockfd, &writeset);
		tv.tv_sec=timeout;
		tv.tv_usec=0;

		if (select( (*sockfd) + 1, NULL, &writeset, NULL, &tv) < 0)
			return (-1);

		if (!FD_ISSET(*sockfd, &writeset))
			return (-1);

	int	cnt= ::write( *sockfd, p, dsize);

		if (cnt < 0)	return (-1);
		p += cnt;
		dsize -= cnt;
	}
	return (0);
}
