// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#include	"ask.h"
#include	"debug.h"
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	<termios.h>
#include	<iostream.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: ask.C,v 1.3 1998/05/25 06:18:16 mrsam Exp $";

int CAsk::Prompt(LPCTSTR strPrompt, BOOL disableEcho)
{
struct termios ts;

	if (!isatty(0))
	{
		TRACE(1, "Input not from terminal.\n");
		return (FALSE);
	}

	if (disableEcho)
	{
		tcgetattr(0, &ts);
		ts.c_lflag &= ~ECHO;
		tcsetattr(0, 0, &ts);
	}
	cout << strPrompt;
	(*this) << cin;

	if (disableEcho)
	{
		cout << "\n";
		ts.c_lflag |= ECHO;
		tcsetattr(0, 0, &ts);
	}
	return (TRUE);
}
