// DSTART
//                      getpop3 - a POP3 client for Linux.
// 
//                    Copyright 1996-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// 
// DEND
#ifndef	afxdebug_h
#define	debug_h

static const char afxdebug_h_rcsid[]="$Id: afxdebug.h,v 1.1 1997/07/14 02:15:36 mrsam Exp $";

#ifdef	DEBUG

#include	"afxtempl.h"
#include	<iostream.h>

class	AfxDebug	{
	CStringArray	m_debugmodes;
public:
	void	Init(CString modes)
		{
			m_debugmodes=CStringTok(modes, _T(","));
		}
	BOOL	HasMode(CString m)
		{
		size_t l=m_debugmodes.GetSize();
		size_t i;

			for (i=0; i<l; i++)
				if (m == m_debugmodes[i])
					return (TRUE);
			return (FALSE);
		}
} ;

extern AfxDebug afxdebug;	// Must declare in your main

#define IFDEBUG(name, action) if (afxdebug.HasMode(name)) { action }
#else
#define IFDEBUG(name, action)
#endif

#define TRACE(x)	IFDEBUG(_T("trace"), cout << __FILE__ << '(' \
				<< __LINE__ << "): " << x << endl; )

#ifdef	DEBUG
class	AfxDebugFunction {
	LPCTSTR	m_name;
public:
	AfxDebugFunction(LPCTSTR name) : m_name(name)
		{
			IFDEBUG(_T("func"), cout << "Entering " << m_name << endl;)
		}
	~AfxDebugFunction()
		{
			IFDEBUG(_T("func"), cout << "Exiting " << m_name<< endl;)
		}
} ;

#define	TRACE_FUNCTION(name) AfxDebugFunction debug_function(name);
#else
#define	TRACE_FUNCTION(name)
#endif

#endif
