# parse a mime multipart
sub parsemimemulti {
  local($fid,$mpos,$mtype,$bound) = @_;
  local($type,$subtype,$param,$enc,$id,$desc);
  local($cont,$newbound,$fieldbody,$fieldname);

  print STDERR "MIME part: multipart/$mtype\t>$bound<\n" if $debug;
  &towish($signalmime);
  &towish("multipart");
  &towish($mtype);

  $cont = 1;
  do {
    &ioset;
    while(<$fid>) {
      print STDERR "\t$_" if $debug;
      chop;
      if (m/^.*From/o && &newmsg($_)) {
	return 0;
      }
      if ($_ eq "--$bound--") { $cont = 0; last; }
      if ($_ eq "--$bound") { last; }  
    }
  } while (&ioerror);
  if(!$_) { return 0; }

 MULTI: while ($cont) {
    if ($mtype =~ m/digest/i) {
      $type = "message"; $subtype = "rfc822"; $param = "";
    } else {
      $type = "text"; $subtype = "plain"; $param = "charset=us-ascii";
    }
    $enc = "7bit"; $id = ""; $desc = "";

    $fieldbody = "";
    $fieldname = "";
    do {
      &ioset;
      while(<$fid>) {
	chop;
	if(m/^\s+\S/) {
	  s/^\s*/ /;
	  $fieldbody .= $_;
	  next;
	} else {
	  if ($fieldname ne "") {
	    if ($fieldname eq "content-type") {
	      ($type,$param) =  split(m/;/,$fieldbody,2);
	      $type =~ tr/A-Z/a-z/;
	      ($type,$subtype) = split(m/\//,&nocomment($type));
	    } elsif ($fieldname eq "content-transfer-encoding") {
	      ($enc = &nocomment($fieldbody)) =~ tr/A-Z/a-z/;;
	    } elsif ($fieldname eq "content-id") {
	      $id = &nocomment($fieldbody);
	    } elsif ($fieldname eq "content-description") {
	      $desc = &nocomment($fieldbody);
	    }
	  }
	  if(m/^\s*$/) { 
	    last; 
	  }
	  if (m/^--$bound/) { last; }
	  ($fieldname,$fieldbody) = split(": *",$_,2);
	  ($fieldname = $fieldname) =~ tr/A-Z/a-z/;
	}
      }
    } while (&ioerror);

    if (m/^--$bound--\s*$/) { last MULTI; }
    if (m/^--$bound\s*$/) { next; }

    if ($type eq "multipart") {
      ($newbound) = $param =~ m/boundary=\"*([^;\"]+)/i;
      $cont = &parsemimemulti($fid,$mpos,$subtype,$newbound);
      do {
	&ioset;
	while(<$fid>) {
	  chop;
	  if (m/^--$bound--\s*$/) { last MULTI; }
	  if (m/^--$bound\s*$/) { next MULTI; }
	  if (m/^.*From/o && &newmsg($_)) { 
	    print STDERR "ERROR: MIME multipart ended prematurely\n";
	    return 0; 
	  }
	}
      } while (&ioerror);
    } elsif ($type eq "message" && $subtype eq "external-body") {
      $cont = &parseexternal($fid,$mpos,$type,$subtype,$param,$enc,
			     $id,$desc,$mtype,$bound);
    } else {
      $cont = &parsemime($fid,$mpos,$type,$subtype,$param,$enc,
			 $id,$desc,$mtype,$bound);
    }
  }
  &towish($signalmime);
  &towish("multipart");
  &towish("end");
  return 1;
}

# parse a mime message
sub parsemime {
  local($fid,$mpos,$type,$subtype,$param,$enc,$id,
	$desc,$mtype,$bound) = @_;
  local($look,$tmpfile,$tfid,$mimeerror,$echo,$filepos,$cont);
  local($pid,$num,$tot,$decodecmd,$unknownenc,$partname);

  print STDERR "MIME part: $type/$subtype\t$bound\n" if $debug;

  ($partname) = $param =~ m/name=\"*([^;\"]+)/i;

  # signal wish as to the mime parts
  &towish($signalmime);
  &towish($type);
  &towish($subtype);
  &towish($param);
  &towish($id);
  if ($partname eq "" || $desc ne "") {
    &towish($desc);
  } else { &towish($partname); }

  $tmpfile = "";
  $echo = 0;
  $unknownenc = 0;
  if ($enc eq "") { $enc = "7bit"; }
  if ($type eq "text" && ($enc =~ m/[78]bit|binary/) && $mtype ne "alternative") {
    $tfid = "WISH";
    $echo = 1;
  } elsif ($type eq "message" && $subtype eq "rfc822" && $mtype ne "digest") {
    $filepos = tell($fid);
    if ($mtype eq "alternative") {
      $tmpfile = "$fid\t$filepos\t$bound";
      return(&abortmime($fid,$type,$subtype,$bound,$tmpfile));
    }
    &towish("");
    &towish($signalmimeend);
    return(&parserfc822($fid,$filepos,$bound));    
  } elsif ($type eq "application" && $subtype eq "octet-stream" && $enc eq "x-uue") {
    print STDERR "Proccessing x-uue enclosure\n" if $debug;
    $filepos = tell($fid);
    do {
      &ioset;
      while(<$fid>) {
	if (m/^.*From/o && &newmsg($_)) { last; }
	if ($bound ne "" && m/^--$bound/) { last; }
	if (m/^begin/o) { last; }
      }
    } while (&ioerror);
    if (($encfile) = m/^begin\s+[0-9]+\s+(.+)$/o) {
      print STDERR "Enclosed file is named $encfile\n" if $debug;
      $tmpfile = "\004$fid\t$filepos\t$bound\t$encfile\t$enc";
      return(&abortmime($fid,$type,$subtype,$bound,$tmpfile));
    } else {
      print WISH "\nERROR trying to parse MIME: $type/$subtype $enc";
      print WISH "\n      Can't find begin of uuencode block\n";
      return(&abortmime($fid,$type,$subtype,$bound,""));
    }
  } elsif ($type eq "message" && $subtype eq "partial") {
    $filepos = tell($fid);
    ($pid) = $param =~ m/id=\"*([^;\"]+)/;
    ($num) = $param  =~ m/number=([0-9]+)/;
    ($tot) = $param  =~ m/total=([0-9]+)/;
    $tmpfile = "$fid\t$filepos\t$mpos\t$pid\t$num\t$tot\t$bound";
    return(&abortmime($fid,$type,$subtype,$bound,$tmpfile));
  } else {
    # see if previously parsed
    local(*mimefiles) = "mime_$fid";
    $filepos = tell($fid);
    $tmpfile = $mimefiles{$filepos};
    if (defined($tmpfile) && -r $tmpfile) { 
      $echo = 0; $tfid = "";
    } else {
      while( -e ($tmpfile = "${tmpdir}/tkmail_mm$<." . $nexttmp++)) { 1;}
      $mimefiles{$filepos} = $tmpfile;
      $tfid = "MIMETFILE";
      $echo = 1;
      if ($enc eq "base64") {
	$decodecmd = "| $base64dec > $tmpfile";
	if (!open($tfid, $decodecmd)) {
	  $lasterror = "Can't execute pipe command: $decodecmd\n$@";
	  return(&abortmime($fid,$type,$subtype,$bound,""));
	}
      } elsif ($enc eq "x-compress64") {
	$decodecmd = "| $base64dec | uncompress > $tmpfile";
	if (!open($tfid, $decodecmd)) {
	  $lasterror = "Can't execute pipe command: $decodecmd\n$@";
	  return(&abortmime($fid,$type,$subtype,$bound,""));
	}
      } elsif ($enc eq "quoted-printable") {
	$decodecmd = "| $quotprdec > $tmpfile";
	if (!open($tfid, $decodecmd)) {
	  $lasterror = "Can't execute pipe command: $decodecmd\n$@";
	  return(&abortmime($fid,$type,$subtype,$bound,""));
	}
      } else {
	if (!$enc =~ m/[78]bit|binary/) { $unknownenc = 1; }
	$decodecmd = "| cat > $tmpfile";
	if (!open($tfid,">$tmpfile")) {
	  $lasterror = "Can't open tmpfile $tmpfile for writing\n$@";
	  return(&abortmime($fid,$type,$subtype,$bound,""));
	}
      }
      print STDERR "      Running: $decodecmd\n" if $debug;
    }
  }

  if ($bound ne "") { $look = 1; }
  else { $look = 0; }

  if ($tfid eq "WISH") { &towish(""); }
  do {
    &ioset;
    while(<$fid>) {
      if (m/^.*From/o && &newmsg($_)) {
	last;
      }
      if ($look && m/^--$bound/) {
	last;
      }
      if ($echo) { print $tfid $_ };
    }
  } while (&ioerror);
  if (m/^--$bound[^-]/) { $cont = 1; }
  else { $cont = 0; }

  if ($tfid eq "MIMETFILE" && $echo) { 
    close($tfid) || warn "Error closing $tmpfile\n"; 
  }

  if ($unknownenc) {
    $lasterror = "Invalid MIME encoding type: $enc\n";
    print WISH "\nERROR trying to parse MIME: $type/$subtype";
    print WISH $lasterror;
    print WISH "Extracted contents to $tmpfile which you may copy elsewhere\n";
  } elsif ($type eq "text" && $tmpfile ne "" 
      && ($mtype ne "alternative")) {
    # if it was encoded text, go ahead and echo the results to WISH
    if (!open($tfid,"<$tmpfile")) {
      $lasterror = "Can't open tmpfile $tmpfile for reading\n$!";
      print WISH "\nERROR trying to parse MIME: $type/$subtype $enc";
      print WISH $lasterror, "\n";
    } else {
      print WISH "\n";
      do {
	&ioset;
	while(<$tfid>) {
	  print WISH $_;
	}
      } while (&ioerror);
      close($tfid) || warn "Error closing $tmpfile\n";
    }
  } else {
    &towish($tmpfile);
  }

  &towish($signalmimeend);
  return $cont;
}

# parse an external mime message
sub parseexternal {
  local($fid,$mpos,$type,$subtype,$param,$enc,$id,$desc,$mtype,$bound) = @_;
  local($accesstype,$expire,$permission,$size,$name,$tmpfile,$tfid);
  local($testline,$fieldbody,$fieldname,$newparam,$filepos);
  local($site,$directory,$mode,$server,$subject);

  ($accesstype) = $param =~ m/access-type=\"*([^;\"]+)/i;
  ($accesstype = $accesstype) =~ tr/A-Z/a-z/;
  ($name) = $param =~ m/name=\"*([^;\"]+)/i;
  ($expire) = $param =~ m/expiration=\"*([^;\"]+)/i;
  ($size) = $param =~ m/size=\"*([^;\"]+)/i;
  ($permission) = $param =~ m/permission=\"*([^;\"]+)/i;
  $filepos = tell($fid);
  
  $type = "text"; $subtype = "plain";
  $enc = "7bit"; $newparam = "charset=us-ascii";
  do {
    &ioset;
    while(<$fid>) {
      chop;
      if(m/^\s+\S/) {
	s/^\s*/ /;
	$fieldbody .= $_;
	next;
      } else {
	if ($fieldname ne "") {
	  if ($fieldname =~ m/^content-type/io) {
	      ($type,$newparam) =  split(m/;/,$fieldbody,2);
	      $type =~ tr/A-Z/a-z/;
	      ($type,$subtype) = split(m/\//,&nocomment($type));
	  } elsif ($fieldname =~ m/^content-id$/io) {
	    $id = $fieldbody;
	  } elsif ($fieldname =~ m/^content-description$/io) {
	    $desc = $fieldbody;
	  } elsif ($fieldname =~ m/^content-transfer-encoding$/io) {
	    $enc = $fieldbody;
	  }
	}
	if(m/^\s*$/) { 
	  last; 
	}
	($fieldname,$fieldbody) = split(": *",$_,2);
      }
    }
  } while (&ioerror);

  print STDERR "EXTERNAL part: $type/$subtype\tname=$name\n" if $debug;

  # signal wish as to the mime parts
  &towish($signalmime);
  &towish($type);
  &towish($subtype);
  &towish($newparam);
  &towish($id);
  &towish($desc);

  # check if file already fetched, decoded and cached
  local(*mimefiles) = "mime_$fid";
  $tmpfile = $mimefiles{$filepos};
  if (defined($tmpfile) && -r $tmpfile) {
    return(&abortmime($fid,$type,$subtype,$bound,$tmpfile));
  } else {
    $tmpfile = "external: $param; ENCODING=$enc; FILE-ID=$fid; FILEPOS=$filepos";
  }

  $lasterror = "Sorry, tkmail can't do message/external-body with access $accesstype yet\n";
  if ($accesstype eq "local-file") {
    if (! -r $name) {
      $lasterror = "A message/external part references non-readable file $name\n";
    } else {
      return(&abortmime($fid,$type,$subtype,$bound,$tmpfile));
    }
  } elsif ( index($accesstype,"ftp") > -1 ) {
    ($site) = $param =~ m/site=\"*([^;\"]+)/i;
    ($directory) = $param =~ m/directory=\"*([^;\"]+)/i;
    ($mode) = $param =~ m/mode=\"*([^;\"]+)/i;
    $lasterror .= "\tRemote file is ${site}:${directory}/$name\n";
  }
  return(&abortmime($fid,$type,$subtype,$bound,""));
}

# parse a partial mime message
sub parsepartial {
  local($fid,$filepos,$mpos,$pid,$num,$tot,$bound) = @_;
  local($look,$tmpfile,$tfid,$nlcnt);
  local($fieldbody,$field,$testline,$partsdir,$piddir,$done,$pnum);

  print STDERR "MIME: Extracting message/partial part $num of $pid\n" if $debug;

  $tfid = "";
  $partsdir = "${tmpdir}/message-parts-$whoami";
  $piddir = "$partsdir/$pid";
  seek($fid,$filepos,0);

  if ($pid eq "" || $num eq "") {
    $lasterror = "Bad ID for MIME message/partial\n";
    return("255");
  } else {
    # create parts directory if needed
    if (! -d $partsdir) {
      if (-e $partsdir) {
	$lasterror = "Can't create directory $partsdir. Already exits.";
	return("255");
      } else {
	if (!mkdir($partsdir,0700)) {
	  $lasterror = "Can't create directory $partsdir\nmkdir: $!";
	  return(sprintf("%d",$!));
	}
      }
    }
    # created subdirectory for this id if needed
    if (! -d $piddir) {
      if (-e $piddir) {
	$lasterror = "Can't create directory $piddir. Already exits.";
	return("255");
      } else {
	if (!mkdir($piddir,0700)) {
	  $lasterror = "Can't create directory $piddir\nmkdir: $!";
	  return(sprintf("%d",$!));
	}
      }
    }
    # check CT file, create it if needed
    if (! -e "$piddir/CT" && $tot ne "") {
      if (!open(CT,">$piddir/CT")) {
	$lasterror = "Can't create file $piddir/CT\nopen: $!";
	return(sprintf("%d",$!));
      }
      print CT "$tot\n";
      close(CT);
    } elsif (-r "$piddir/CT") {
      if (!open(CT,"<$piddir/CT")) {
	$lasterror = "Can't open file $piddir/CT\nopen: $!";
	return(sprintf("%d",$!));
      }
      chop($cttot = <CT>);
      close(CT);
      if ($tot eq "" ) { $tot = $cttot; }
      elsif ($cttot != $tot) {
	$lasterror = "$piddir/CT doesn't match total param to $type/$subtype id=$pid";
	return("255");
      }
    }
    # check if this part already written
    $tmpfile = "$piddir/$num";
    $tfid = "MIMETFILE";
    if (!open($tfid,">$tmpfile")) {
      $lasterror = "Can't open $tmpfile for writing\n$!";
      return(sprintf("%d",$!));
    } else { 
      if ($num == 1) {
	# copy relevant info from current messages main headers
	seek($fid,$mpos,0);
	print $tfid &safeio($fid);
	do {
	  &ioset;
	  while(<$fid>) {
	    if(m/^\s+\S/) {
	      s/^\s*/ /;
	      $fieldbody .= $_;
	      next;
	    } else {
	      if ($fieldname ne "") {
		if (!($fieldname =~ m/^content-/io ||
		      $fieldname =~ m/^message-id$/io ||
		      $fieldname =~ m/^encrypted$/io ||
		      $fieldname =~ m/^mime-version$/io)) {
		  print $tfid $fieldname, ": ", $fieldbody;
		}
	      }
	      if(m/^\s*$/) { 
		last; 
	      }
	      ($fieldname,$fieldbody) = split(": *",$_,2);
	    }
	  }
	} while (&ioerror);
	seek($fid,$filepos,0);
	$testline = &safeio("$fid");
	($fieldname,$fieldbody) = split(": *",$testline,2);
	if ($fieldbody eq "" || $fieldname =~ m/\s/) {
	  print $tfid "\n";
	  print $tfid $testline;
	} else {
	  do {
	    &ioset;
	    while(<$fid>) {
	      if(m/^\s+\S/) {
		s/^\s*/ /;
		$fieldbody .= $_;
		next;
	      } else {
		if ($fieldname ne "") {
		  if ($fieldname =~ m/^content-/io ||
		      $fieldname =~ m/^message-id$/io ||
		      $fieldname =~ m/^encrypted$/io ||
		      $fieldname =~ m/^mime-version$/io) {
		    print $tfid $fieldname, ": ", $fieldbody;
		  }
		}
		if(m/^\s*$/) { 
		  print $tfid "\n";
		  last; 
		}
		($fieldname,$fieldbody) = split(": *",$_,2);
	      }
	    }
	  } while (&ioerror);
	} # embedded header
      } # first part
    } # open tmpfile successful
  } # good params

  if ($bound ne "") { $look = 1; }
  else { $look = 0; }

  do {
    &ioset;
    while(<$fid>) {
      if (m/^.*From/o && &newmsg($_)) {
	last;
      }
      if ($look && m/^--$bound/) {
	last;
      }
      print $tfid $_;
    }
  } while (&ioerror);
  close($tfid);
  if ($tot ne "") {
    $done = grep(-r "$piddir/$_", 1..$tot);
    if ($done == $tot) {
      while( -e ($tmpfile = "${tmpdir}/tkmail_mm$<." . $nexttmp++)) { 1;}
      if (!open($tfid,">$tmpfile")) {
	$lasterror = "Can't open $tmpfile for writing\n$!";
	print WISH "\nERROR trying to parse MIME: $type/$subtype\n$lasterror\n";
	return("255");
      }
      foreach $pnum (1..$tot) {
	if (!open(MIMEPART,"<$piddir/$pnum")) {
	  $lasterror = "Can't open $piddir/$pnum for reading\n$!";
	  print WISH "\nERROR trying to parse MIME: $type/$subtype\n$lasterror\n";
	  close($tfid);
	  unlink($tmpfile);
	  return("255");
	}
	$nlcnt = 0;
	do {
	  &ioset;
	  while(<MIMEPART>) {
	    if ($_ eq "\n") { $nlcnt++; }
	    else {
	      if ($nlcnt) { while($nlcnt--) { print $tfid "\n"; } $nlcnt = 0; }
	      print $tfid $_;
	    }
	  }
	} while (&ioerror);
	close(MIMEPART);
      }
      if ($nlcnt) { while($nlcnt--) { print $tfid "\n"; } }
      close($tfid);
      foreach $pnum (1..$tot) { unlink("$piddir/$pnum"); }
      unlink("$piddir/CT");
      rmdir($piddir) || warn "Can't remove dir $piddir\n$!\n";
      rmdir($partsdir);
      &towish("$tmpfile");
      &towish("Extracted all $tot parts for message/partial id=$pid");
    } else {
      &towish("");
      &towish("Extracted part $num/$tot for message/partial id=$pid ($done parts done)");
    }
  } else {
    &towish("");
    &towish("Extracted part $num for message/partial id=$pid");
  }

  return("0");
}

# abort a mime parsing of message part
sub abortmime {
  local($fid,$type,$subtype,$bound,$tmpfile) = @_;
  local($look);

  if ($bound ne "") { $look = 1; }
  else { $look = 0; }

  do {
    &ioset;
    while(<$fid>) {
      if (m/^.*From/o && &newmsg($_)) {
	last;
      }
      if ($look && m/^--$bound/) {
	last;
      }
    }
  } while (&ioerror);
  if ($tmpfile eq "") {
    print WISH "\nERROR trying to parse MIME: $type/$subtype\n$lasterror\n";
  } else {
    print WISH "$tmpfile\n";
  }
  &towish($signalmimeend);

  if (m/^--$bound[^-]/) { return 1; }
  return 0;
}

sub mimedecode {
  local($enc,$filename,$fid,$filepos) = @_;
  local($tmpfile,$tfid,$decodecmd);

  local(*mimefiles) = "mime_$fid";
  $tmpfile = $mimefiles{$filepos};
  if (!(defined($tmpfile) && -r $tmpfile)) { 
    while( -e ($tmpfile = "${tmpdir}/tkmail_mm$<." . $nexttmp++)) { 1;}
    $mimefiles{$filepos} = $tmpfile;
    $tfid = "MIMETFILE";

    if ($enc eq "base64") {
      $decodecmd = $base64dec . " $filename > " . $tmpfile;
      if (system($decodecmd)) {
	$lasterror = "Can't execute pipe command: $decodecmd\n$!";
	return 255;
      }
    } elsif ($enc eq "quoted-printable") {
      $decodecmd = $quotprdec . " $filename > " . $tmpfile;
      if (system($decodecmd)) {
	$lasterror = "Can't execute pipe command: $decodecmd\n$!";
	return 255;
      }
    } else {
      $lasterror = "Don't no how to decode $enc";
      return 255;
    }
  }

  &towish($tmpfile);
  return 0;
}

sub parserfc822 {
  local($fid,$filepos,$bound) = @_;    
  local($testline,$filename,$fieldname,$fieldbody,%fielddb);
  local($type,$subtype,$param,$enc,$id,$desc,$newbound);

  if (!defined($foldersize{$fid})) {
    $filename = $fid;
    if ( ! -r $filename ) {
      $lasterror = "Invalid file identifier or filename given to parserfc822";
      return 255;
    }
    $fid = ++$nexthandle;
    if (!open($fid, "<$filename")) {
      $lasterror = "$filename: $!";
      return(sprintf("%d",$!));
    }
  } else {
    seek($fid,$filepos,0);
  }

  $testline = &safeio($fid);
  ($fieldname,$fieldbody) = split(": *",$testline,2);
  if ($fieldbody eq "" || $fieldname =~ m/\s/) {
    print WISH "\n";
    print WISH $testline;
  } else {
    do {
      &ioset;
      while(<$fid>) {
	print WISH $_;
	if(m/^\s+\S/) {
	  s/^\s*/ /;
	  $fieldbody .= $_;
	  next;
	} else {
	  if ($fieldname ne "") {
	    if ($fieldname =~ m/^content-/io ||
		$fieldname =~ m/^message-id$/io ||
		$fieldname =~ m/^encrypted$/io ||
		$fieldname =~ m/^mime-version$/io) {
	      $fielddb{$fieldname} = $fieldbody;
	    }
	  }
	  if(m/^\s*$/) { 
	    print WISH "\n";
	    last; 
	  }
	  ($fieldname,$fieldbody) = split(": *",$_,2);
	}
      }
    } while (&ioerror);
  }

  if (defined($fielddb{"mime-version"}) || defined($fielddb{"content-type"})) {
    print STDERR "Parsing enclosed MIME message\n" if $debug;

    ($type,$param) = 
      split(m/;/,$fielddb{"content-type"},2);
    $type =~ tr/A-Z/a-z/;
    ($type,$subtype) = split(m/\//,&nocomment($type));
    $enc = &nocomment($fielddb{"content-transfer-encoding"});
    $enc =~ tr/A-Z/a-z/;
    $id = &nocomment($fielddb{"content-id"});
    $desc = &nocomment($fielddb{"content-description"});

    if ($type =~ m/multipart/i) {
      ($newbound) = $param =~ m/boundary=\"*([^;\"]+)/i;
      if(&parsemimemulti($fid,$filepos,$subtype,$newbound)) {
	do {
	  &ioset;
	  while(<$fid>) {
	    if (m/^.*From/o && &newmsg($_) || m/^--$bound--/) {
	      return 0;
	    }
	    if (m/^--$bound/) {
	      return 1;
	    }
	  }
	} while (&ioerror);
      }
      return 0;
    } else {
      if ($type eq "") { 
	$type = "text"; $subtype = "plain"; $param = "charset=us-ascii";
      }
      return(&parsemime($fid,$filepos,$type,$subtype,$param,$enc,
		 $id,$desc,"mixed",$bound));
    }

  } else {

    if ($bound ne "") { $look = 1; }
    else { $look = 0; }

    # send mesg body
    do {
      &ioset;
      while(<$fid>) {
	if (m/^.*From/o && &newmsg($_)) {
	  last;
	}
	if ($look && m/^--$bound/) {
	  last;
	}
	print WISH $_;
      }
    } while (&ioerror);
    if (m/^--$bound[^-]/) { return 1; }
    return 0;
  }

}

sub parseoctet {
  local($fid,$filepos,$bound,$encfile,$enc,$dir) = @_;    
  local($decodecmd,$look,$tfid,$savedir);

  print STDERR "Creating enclosed file $encfile to $dir\n" if $debug;

  if (!defined($foldersize{$fid})) {
    $lasterror = "Invalid file identifier given to parseoctet";
    return 255;
  } else {
    seek($fid,$filepos,0);
  }

  $savedir = $ENV{"PWD"};

  if ($enc eq "x-uue") {
    if (-d $dir) { &chdir($dir); }
    $decodecmd = "| uudecode ";
    if (!open($tfid, $decodecmd)) {
      $lasterror = "Can't execute pipe command: $decodecmd\n$@";
      &chdir($savedir);
      return 255;
    }
  } else {
    $lasterror = "Don't know how to handle encoding $enc\n";
    return 255;
  }

  if ($bound ne "") { $look = 1; }
  else { $look = 0; }

  do {
    &ioset;
    while(<$fid>) {
      if (m/^.*From/o && &newmsg($_)) { last; }
      if ($look && m/^--$bound/) { last; }
      print $tfid $_;
    }
  } while (&ioerror);
  close($tfid) || warn "Error closing $tmpfile\n"; 
  &chdir($savedir);
  return 0;

}

#  Example of spliting on ; not inside (),"", or <>
#
#  @array = ();
#  push(@array, $&) while m/([^;"(<]+|"[^"]*"|\([^)]*\)|<[^>]*>)+/g;

######################### required for require #######################################
1; 

