#!/bin/sh
#
# install.sh
# $Id: Install.sh,v 2.1 1998/09/13 10:44:27 beckerr Exp $
#
# Installes XCmail and all required components
#
# (c) 1998 by XCmail development team (xc-mail-developers@fsai.fh-trier.de)
#

if test -n "$1"; then
	_XCMAILBIN=$1
	_XCMAILDIR=$2
else
	_XCMAILBIN='/usr/local/bin'
	_XCMAILDIR=$XCMAILDIR
	if [ "$XCMAILDIR" ]; then
	  _XCMAILDIR="$XCMAILDIR"
	else
	  _XCMAILDIR='/usr/local/XCmail'
	fi
	_DYNAMIC="N"
fi

echo_n() {
	if test "`echo -n`" = "-n" ; then
		if test "`echo \c`" = 'c' ; then
			printf "$@"
		else
			echo "$@""\c"
		fi
	else
		echo -n "$@"
	fi
}

clear
echo
echo "                                                  |"
echo "                                                  |"
echo " XCmail interactive installation                  |"
echo "                                                  |"
echo "+-------------------------------------------------+"
echo "|"
echo "| By default the XCmail binary should be placed in"
echo "| '/usr/local/bin' or '/usr/bin'. All other files"
echo "| like default setups, global plugins or config files"
echo "| will be installed in '/usr/local/XCmail'."
echo "|"
echo "| We will now go and verify this directories and"
echo "| change them to your needs."
echo "|"

echo
echo "Where should the main program be installed to?"
echo_n "[$_XCMAILBIN]: "
read dummy
if test X$dummy != X ; then
  _XCMAILBIN="$dummy"
fi

echo
echo "Where should the extra files be placed in?"
echo_n "[$_XCMAILDIR]: "
read dummy
if test X"$dummy" != X ; then
  _XCMAILDIR="$dummy"
fi

if test -d src ; then
	SRC=src
else
	SRC=.
fi

if test -f "$SRC/xc-mail_s" -a -f "$SRC/xc-mail" ; then
 echo
 echo "We have a dynamic and a static release of XCmail included"
 echo "in this achive. Static means Xclasses library is linked in"
 echo "the binary, dynamic means you need Xclasses library installed"
 echo "on your system."
 echo
 echo_n "Which should be installed, the dynamic releases? (y/N) "
 read dummy
 if test "$dummy" = y -o "$dummy" = Y ; then
   _DYNAMIC="Y"
 fi
fi

if ls plugins/*/*_pl.o >/dev/null 2>/dev/null ; then
	PLUGINS_DIR=plugins/*
elif ls plugins/*_pl.o >/dev/null 2>/dev/null ; then
	PLUGINS_DIR=plugins
else
	PLUGINS_DIR=
fi

PLUG_INSTALL=

if test X$PLUGINS_DIR != X; then

	done=false
	
	while ! $done ; do

		err=false
		done=true
		
	 	echo
		echo "Please choice the plugins to be installed:"
		echo
		
		i=1
		for plug in $PLUGINS_DIR/*_pl.o ; do

			if test -f $_XCMAILDIR/plugins/`basename $plug` ; then
				if test -z "$INSTALLED" ; then
					INSTALLED=$i
				else
					INSTALLED="$INSTALLED,$i"
				fi
			fi
			
			plug_name=`basename $plug _pl.o`
		
			printf " %2s) $plug_name\n" $i
		
			about=`dirname $plug`/ABOUT
			if test -f $about; then :
			else
				about=`dirname $plug`/$plug_name.ABOUT
			fi
			if test -f $about ; then
				cat $about | sed 's/^\(................................................[^ ]*\) /\1\
/' | sed -e 's/^/       /'
			fi
			i=`expr $i + 1`
		done

		echo
		echo "enter plugin list (eg. 1,2,4 or"
		echo_n "  NONE=none or [RETURN]=${INSTALLED=all}): "
		read plug_list || exit 1
	
		if [ -z "$plug_list" ] ; then
			if [ -z "$INSTALLED" ] ; then
				PLUG_INSTALL=`ls $PLUGINS_DIR/*_pl.o`
			else
				plug_list="$INSTALLED"
			fi
		fi

		if [ -n "$plug_list" ] ; then
			for i in `echo $plug_list | sed -e 's/,/ /g'` ; do
				if [ -z "`echo $i | sed 's/[0-9]//g'`" ] ; then
					n=`ls -1 $PLUGINS_DIR/*_pl.o | awk '{if(++i=='$i')print}'`
					if [ -z "$n" ] ; then
						echo "  Unknown plugin number $i!"
						err=true
					else
						PLUG_INSTALL="$PLUG_INSTALL $n"
					fi
				else
					err=true
				fi
			done
		fi
		if $err ; then
			PLUG_INSTALL=
			if [ "`echo $plug_list | tr '[A-Z]' '[a-z]'`" != "none" ] ; then
				echo
				echo "Yeah guy...what do you want!?"
				sleep 2
				done=false
			fi
		fi
	done
fi

echo
echo
echo "Ok. We will now copy the files:"
echo " - binary to $_XCMAILBIN"
echo " - other files to $_XCMAILDIR"
if [ -z "$PLUG_INSTALL" ] ; then
	echo " - plugins: (none}"
else
	echo " - plugins:" `echo ${PLUG_INSTALL} | sed -e 's,[^ ]*/,,g' -e 's,_pl.o,,g'`
fi
echo

echo_n "Is this correct? (y/N) "
read dummy
echo
if [ "$dummy" != "y" -a "$dummy" != "Y" ]; then
  echo
  echo "As you wished it, leaving!"
  echo
  exit
fi

# --- main -----------------------------------------------------------
if [ ! -d "$_XCMAILBIN" ]; then
  echo "Directory $_XCMAILBIN not found!"
  echo "Aborting."
  exit
fi

if [ -f "$SRC/xc-mail" -o "$_DYNAMIC" = "Y" ]; then
  cp $SRC/xc-mail $_XCMAILBIN
fi
if [ -f "$SRC/xc-mail_s" -a "$_DYNAMIC" = "N" ]; then
  cp $SRC/xc-mail_s $_XCMAILBIN/xc-mail
fi

chmod 755 $_XCMAILBIN/xc-mail

if [ ! -f "$_XCMAILBIN/xcmail" ]; then
  ln -s $_XCMAILBIN/xc-mail $_XCMAILBIN/xcmail
fi
if [ ! -f "$_XCMAILBIN/XCmail" ]; then
  ln -s $_XCMAILBIN/xc-mail $_XCMAILBIN/XCmail
fi

echo "XCmail main program copied and installed."

# --- globals dir ----------------------------------------------------
if [ ! -d "$_XCMAILDIR" ]; then
  mkdir $_XCMAILDIR && chmod 755 $_XCMAILDIR
fi

if [ ! -d "$_XCMAILDIR" ]; then
  echo "Directory $_XCMAILDIR could not be created!"
  echo "Aborting."
  exit
fi

# --- plugins --------------------------------------------------------
if [ ! -d "$_XCMAILDIR/plugins" ]; then
  mkdir $_XCMAILDIR/plugins && chmod 755 $_XCMAILDIR/plugins
fi

if [ -n "$PLUG_INSTALL" ] ; then
  if [ -d "$_XCMAILDIR/plugins" ]; then
	cp $PLUG_INSTALL $_XCMAILDIR/plugins && chmod 755 $_XCMAILDIR/plugins/*
	echo "Plugins copied and installed."
  fi
fi

# --- converters -----------------------------------------------------
if [ ! -d "$_XCMAILDIR/converters" ]; then
  mkdir $_XCMAILDIR/converters && chmod 755 $_XCMAILDIR/converters
fi

if [ "`ls converters/* 2>/dev/null`" ]; then
  if [ -d "$_XCMAILDIR/converters" ]; then
	for i in converters/* ; do
		if test -d $i ; then :
		elif expr "$i" : "converters/Makefile.*" >/dev/null; then :
		elif expr "$i" : "converters/README" >/dev/null; then
    		cp $i $_XCMAILDIR/converters && chmod 644 $_XCMAILDIR/$i
		else
    		cp $i $_XCMAILDIR/converters && chmod 755 $_XCMAILDIR/$i
		fi
	done
	echo "Converters copied and installed."
  fi
fi

# --- finished -------------------------------------------------------

echo
echo "|"
echo "| Done."
echo "| XCmail may now the started with 'xc-mail', 'xcmail' or 'XCmail'."
echo "| To use the global resource directory '$_XCMAILDIR'"
echo "| you should set the environment variable 'XCMAILDIR' to this"
echo "| directory (XCMAILDIR=$_XCMAILDIR eg. in you global or local profile)."
echo "|"
echo "+----------------------------------------------------> have fun!"
echo
