/****************************************************************************
* SCM Vn 2.0  April 2004
* Developed by Mike Eggleston (Fenland Software Ltd) from
*
*        spam mail counter-measure (SCM Vn 1.4)
*        By Jason Nunn <jsno@downunder.net.au>, May 2000
*        Darwin, NT, Australia
*
* Copyright (c) 2000  Jason Dunn
* Additional Code Copyright (c) 2004 Fenland Software Ltd 
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <ctype.h>
#include <netdb.h>
#include <resolv.h>
#include <sys/types.h>
#include <arpa/nameser.h>
#include "scm.h"
#include "misc.h"

int  cmdc;
char **cmdv;

int  filter_f = 0;
int  notify_f = 0;
int  save_spam_f = 0;
int  upd_allow_deny_f = 0;

char procmail_path[STR_LEN + 1] = "";
char sendmail_path[STR_LEN + 1] = "";
char reject_from[STR_LEN + 1] = "";
char accept_from[STR_LEN + 1] = "";
char allow_deny_file[STR_LEN + 1] = "";
char reject_letter[STR_LEN + 1] = "";
char accept_letter[STR_LEN + 1] = "";
char exemption_tok[STR_LEN + 1] = "*";
int  truncation = 0;

tll *allow_ll       = NULL;
tll *deny_ll        = NULL;
tll *dump_ll        = NULL;
tll *me_ll          = NULL;

tell *ell           = NULL;


char *message_buf   = NULL;
char *header_buf    = NULL;

char *hrl_to        = "\nto: ";
char *hrl_from      = "\nfrom: ";
char *hrl_reply_to  = "\nreply-to: ";
char *hrl_subject   = "\nsubject: ";
char *hrl_xsender   = "\nx-sender: ";
char *hrl_ret_path  = "\nreturn-path: ";
char *hrl_cc        = "\ncc: ";

char scm_comments[STR_LEN + 1]   = "";
char emailable_addr[STR_LEN + 1] = "";

/****************************************************************************
*
****************************************************************************/
void atexit_h(void)
{
  print_log('I',"--Ending---------------------------");
}

void init(void)
{
  struct passwd *p;

  seteuid(getuid());
  setegid(getgid());

  p = getpwuid(getuid());
  if(p == NULL)
  {
    printf("Unknown UID %d. Aborting.\n",getuid());
    exit(-1);
  }

  strcpy(home_dir,p->pw_dir);

  atexit(atexit_h);
}

/****************************************************************************
*
****************************************************************************/
void add_ll_entry(tll **ll,char *s)
{
  tll *tmp,*tmp2;

  tmp = malloc(sizeof(tll));
  if(tmp == NULL)
    fatal_malloc_error();

  tmp2 = *ll;
  *ll = tmp;
  strncpy((*ll)->entry,s,STR_LEN_LN);
  (*ll)->entry[STR_LEN_LN] = 0;
  (*ll)->next = tmp2;
}

void stream_2_buf(FILE *fp,char **buffer)
{
  int len = 0;

  *buffer = malloc(1);
  if(*buffer != NULL)
  {
    (*buffer)[0] = 0;
    for(;;)
    {
      char sin[STR_LEN_LN + 1];
      register int s;

      if(feof(fp))
        break;

      if(fgets(sin,STR_LEN_LN,fp) == NULL)
        break;
      s = strlen(sin);
      *buffer = realloc(*buffer,len + s + 1);
      if(*buffer != NULL)
      {
        strcat(*buffer,sin);
        len += s;
      }
      else
        fatal_malloc_error();
    }
  }
  else
    fatal_malloc_error();
}

void append_line(char **buf)
{
  char str[STR_LEN + 1];
  register int n;

  sprintf(str,"\n--\n%s Vn %s - %s\n",PROGNAME, VERSION,scm_comments);
  n = strlen(*buf) + strlen(str) + 1;

  *buf = realloc(*buf,n);
  if(*buf == NULL)
    fatal_malloc_error();

  strncat(*buf,str,n);
}

int get_field(char *stream,char *field,char *dst,int maxsize)
{
  char *s,*e;
  register int l;

  s = strstr(stream,field);

  if(s == NULL)
    return 0;
  s += strlen(field);

  e = strchr(s,'\n');
  if(e == NULL)
    l = strlen(s);
  else
    l = e - s;

  if(l > maxsize)
    l = maxsize;
  strncpy(dst,s,l);
  dst[l] = 0;

  return 1;
}

/****************************************************************************
*
****************************************************************************/

/*
 * str must be free of spaces starting and ending.
 */
int valid_email(char *str)
{
  char *s;
  register int b = 0,c = 0;

  s = str;
  for(;;)
  {
    if(*s == 0)
    {
      if(isspace(*s))
        return 0;

      if(s > str)
      {
        if(*(s - 1) == '.')
          return 0;
      }
      else
        return 0;

      break;
    }

    if(*s == '.')
      b = 1;

    if(*s == '@')
    {
      if(c == 0)
        c = 1;
      else
        return 0;
    }

    s++;
  }

  if((b > 0) && (c == 1))
    return 1;

  return 0;
}

int extract_email_from_field(char *field,char **dstp)
{
  static char name[STR_LEN + 1],email[STR_LEN + 1];
  register int mode = 0,a = 0,b = 0;
  char str[STR_LEN + 1],*s;

  if(!get_field(header_buf,field,str,STR_LEN))
    return 0;

  s = str;
  for(;;)
  {
    if(*s == 0)
      break;

    if(mode == 0)
    {
      if(*s == '<')
        mode = 2;
      else if(!isspace(*s))
        mode = 1;
      else
        s++;
    }
    else if(mode == 1)
    {
      if(isspace(*s))
        mode = 2;
      else
      {
        name[a] = *s;
        a++;
      }
      s++;
    }
    else if(mode == 2)
    {
      if(*s == '<')
        mode = 3;
      s++;
    }
    else if(mode == 3)
    {
      if(*s == '>')
        break;

      email[b] = *s;
      b++;
      s++;
    }
  }
  name[a] = 0;
  email[b] = 0;

  if(valid_email(email))
  {
    *dstp = email;
    return 1;
  }

  if(valid_email(name))
  {
    *dstp = name;
    return 1;
  }

  return 0;
}

/****************************************************************************
*
****************************************************************************/
void add_ell_entry(unsigned int e)
{
  tell *tmp,*tmp2;

  tmp = malloc(sizeof(tell));
  if(tmp == NULL)
    fatal_malloc_error();

  tmp2 = ell;
  ell = tmp;
  ell->entry = e;
  ell->next = tmp2;
}

void free_ell(void)
{
  tell *p;

  p = ell;
  for(;;)
  {
    tell *t;

    if(p == NULL)
      break;

    t = p;
    p = p->next;

    free(t);
  }

  ell = NULL;
}

int compare_addr(char *haystack,char *needle)
{
  tell *p;
  int status = 1,ord = 0xffffffff;

  int cmpr(char *n)
  {
    register int term_l = 0,term_r = 0;
    char *r,*v;

    if(*n == '*')
      n++;
    else
      term_l = 1;

    r = strchr(n,'*');
    if(r != NULL)
      *r = 0;
    else
      term_r = 1;

    v = strstr(haystack,n);
    if(v != NULL)
    {
      register int i = 0;

      if(term_l)
      {
        if(v == haystack)
          i++;
      }
      else
        i++;

      if(term_r)
      {
        if(*(v + strlen(n)) == 0)
          i++;
      }
      else
        i++;

      if(i == 2)
        return (int)(v + 1);
    }

    return 0;
  }

  void decode(char *s)
  {
    char tmps[STR_LEN + 1];
    char *tsp;

    if(*s == 0)
      return;

    tmps[0] = *s;
    s++;
    tsp = tmps + 1;
    for(;;)
    {
      if((tsp - tmps) == STR_LEN)
        break;

      if(*s == 0)
        break;

      *tsp = *s;
      tsp++;

      if(*s == '*')
        break;

      s++;
    }
    *tsp = 0;

    add_ell_entry(cmpr(tmps));

    if((*s != 0) && (*(s + 1) != 0))
      decode(s);
  }

  if(needle[0] == 0)
    return 0;

  decode(needle);
  p = ell;
  for(;;)
  {
    if(p == NULL)
      break;

    if(p->entry == 0)
    {
      status = 0;
      break;
    }

    if(p->entry < ord)
      ord = p->entry;
    else
    {
      status = 0;
      break;
    }

    p = p->next;
  }

  free_ell();

  return status;
}

/****************************************************************************
* parse .scmrc file
****************************************************************************/
int freadln(FILE *fp,char *str)
{
  if(fgets(str,STR_LEN,fp) != NULL)
    if(str[0] != '#')
      return 1;
  return 0;
}

int get_param(char *d_str,char *s_str,char *key,int max)
{
  char tok[STR_LEN + 1],param[STR_LEN + 1];

  tok[0] = 0;
  param[0] = 0;
  if(sscanf(s_str,"%s %s",tok,param) == 0)
    return 0;

  if(!strcmp(tok,key))
  {
    char *s;

    s = strstr(s_str + strlen(tok),param);
    if(s != NULL) strncpy(d_str,s,max);
    d_str[max] = 0;
    s = strchr(d_str,'\n');
    if(s != NULL) *s = 0;
    s = strchr(d_str,'\r');
    if(s != NULL) *s = 0;

    return 1;
  }

  return 0;
}

void load_allow_deny_file(void)
{
  FILE *fp;
  char str[STR_LEN + 1];

  strcpy(str,allow_deny_file);

  if((fp = fopen(str,"r")) == NULL)
    log_error("allow_deny()->fopen()");
  else
  {
    while(!feof(fp))
      if(freadln(fp,str))
      {
        char substr[STR_LEN + 1];
        if(get_param(substr,str,"allow:",STR_LEN))
          add_ll_entry(&allow_ll,substr);

        if(get_param(substr,str,"deny:",STR_LEN))
          add_ll_entry(&deny_ll,substr);

        if(get_param(substr,str,"dump:",STR_LEN))
          add_ll_entry(&dump_ll,substr);
      }
    fclose(fp);
  }
}

void load_conf(void)
{
  FILE *fp;
  char str[STR_LEN + 1];

  strcpy(str,home_dir);
  strcat(str,"/");
  strcat(str,".scmrc");
  if((fp = fopen(str,"r")) == NULL)
  {
    log_error("load_conf()->fopen()");
    exit(-1);
  }

  while(!feof(fp))
    if(freadln(fp,str))
    {
      char substr[STR_LEN + 1];

      if(get_param(substr,str,"filter",STR_LEN))
        filter_f = 1;

      if(get_param(substr,str,"notify_spammer",STR_LEN))
        notify_f = 1;

      if(get_param(substr,str,"save_spam",STR_LEN))
        save_spam_f = 1;

      if(get_param(substr,str,"print_log",STR_LEN))
        print_log_f = 1;

      if(get_param(substr,str,"upd_allow_deny",STR_LEN))
        upd_allow_deny_f = 1;

      if(get_param(substr,str,"procmail_path:",STR_LEN))
        strcpy(procmail_path,substr);

      if(get_param(substr,str,"sendmail_path:",STR_LEN))
        strcpy(sendmail_path,substr);

      if(get_param(substr,str,"reject_from:",STR_LEN))
      {
        strcpy(reject_from,"-f");
        strcat(reject_from,substr);
      }

      if(get_param(substr,str,"reject_letter:",STR_LEN))
        strcpy(reject_letter, substr);

      if(get_param(substr,str,"accept_from:",STR_LEN))
      {
        strcpy(accept_from,"-f");
        strcat(accept_from,substr);
      }

      if(get_param(substr,str,"accept_letter:",STR_LEN))
        strcpy(accept_letter, substr);

      if(get_param(substr,str,"allow_deny_file:",STR_LEN))
        strcpy(allow_deny_file,substr);

      if(get_param(substr,str,"exemption_tok:",STR_LEN))
        strcpy(exemption_tok,substr);

      if(get_param(substr,str,"truncation:",STR_LEN))
      {
        truncation = atoi(substr);
        if(truncation < 8)
          truncation = 0;
      }

      if(get_param(substr,str,"allow:",STR_LEN))
        add_ll_entry(&allow_ll,substr);

      if(get_param(substr,str,"deny:",STR_LEN))
        add_ll_entry(&deny_ll,substr);

      if(get_param(substr,str,"dump:",STR_LEN))
        add_ll_entry(&dump_ll,substr);

      if(get_param(substr,str,"me:",STR_LEN))
        add_ll_entry(&me_ll,substr);

    }

  fclose(fp);

  if(*allow_deny_file)
    load_allow_deny_file();
}

/****************************************************************************
*
****************************************************************************/
int goto_message_body(char **e)
{
  for(;;)
  {
    if(**e == 0)
      return 0;
    if(**e == '\n')
      if(*(*e + 1) == '\n')
        break;
    (*e)++;
  }

  return 1;
}

void convert_header(void)
{
  char *e;
  register int x,l;

  e = message_buf;
  goto_message_body(&e);

  l = e - message_buf;
  header_buf = malloc(l + 1);
  if(header_buf == NULL)
    fatal_malloc_error();

  for(x = 0;x <= l;x++)
    header_buf[x] = tolower(message_buf[x]);
  header_buf[l] = 0;
}

/****************************************************************************
*
****************************************************************************/
int test_ll_2_str(tll *ll,char *str)
{
  tll *p;

  p = ll;
  for(;;)
  {
    if(p == NULL)
      break;

    if(compare_addr(str,p->entry))
      return 1;

    p = p->next;
  }

  return 0;
}

int test_field(tll *ll,char *field)
{
  char *strp;

  if(extract_email_from_field(field,&strp))
    if(test_ll_2_str(ll,strp))
      return 1;

  return 0;
}

/****************************************************************************
* parses email address, currenty tests if address resolves.
****************************************************************************/
int addr_resolvable(char *addr)
{
  unsigned char answer[STR_LEN];

  res_init();
  if(res_query(addr,C_ANY,T_ANY,answer,STR_LEN) == -1)
    return 0;

  return 1;
}

int verify_email_field(char *email,char *fd)
{
  char u[STR_LEN],*s,str[STR_LEN];
  int ret = 1;

  strcpy(u,email);
  s = strchr(u,'@');
  if(s != NULL)
  {
    *s = 0;
    s++;

/*  if(!smtp_verify_user(s,u))*/
    if(!addr_resolvable(s))
    {
      sprintf(str," [%s:!VRFY]",fd);
      strcat(scm_comments,str);
      ret = 0;
    }
    else
      strcpy(emailable_addr,email);
  }
  else
  {
    sprintf(str," [%s:!EMAIL]",fd);
    strcat(scm_comments,str);
    ret = 0;
  }

  return ret;
}

/****************************************************************************
*
****************************************************************************/
int screen_header(void)
{
  register int ret = 0;
  char *strp;

  print_log('I',"screening header.");

  /*
   * if there's a "reply-to:" field, then verify it.
   */
  if(extract_email_from_field(hrl_reply_to,&strp))
  {
    print_log('I',"verifying 'Reply-to:' field.");

    if(!verify_email_field(strp,"RPTO"))
      ret = 1;
  }

  /*
   * if not, then test the "From:" field to see if it has DNS records
   */
  else
  {
    print_log('I',"verifying 'From:' field.");

    if(extract_email_from_field(hrl_from,&strp))
    {
      if(!verify_email_field(strp,"FM"))
        ret = 1;
    }
    else
    {
      strcat(scm_comments," [FM:DEFUNC]");
      ret = 1;  /*field is garbled*/
    }
  }

  /*
   * check header for any instances of deny entries.
   */
  if(test_field(deny_ll,hrl_to))
  {
    strcat(scm_comments," [TO:DENY]");
    ret = 1;
  }

  if(test_field(deny_ll,hrl_from))
  {
    strcat(scm_comments," [FM:DENY]");
    ret = 1;
  }

  if(test_field(deny_ll,hrl_reply_to))
  {
    strcat(scm_comments," [RPTO:DENY]");
    ret = 1;
  }

  if(test_field(deny_ll,hrl_xsender))
  {
    strcat(scm_comments," [XS:DENY]");
    ret = 1;
  }

  if(test_field(deny_ll,hrl_ret_path))
  {
    strcat(scm_comments," [RETP:DENY]");
    ret = 1;
  }

  if(test_field(deny_ll,hrl_cc))
  {
    strcat(scm_comments," [CC:DENY]");
    ret = 1;
  }
  /*
   * check header for any instances of dump entries.
   */
  if(test_field(dump_ll,hrl_to))
  {
    strcat(scm_comments," [TO:DUMP]");
    ret = 2;
  }

  if(test_field(dump_ll,hrl_from))
  {
    strcat(scm_comments," [FM:DUMP]");
    ret = 2;
  }

  if(test_field(dump_ll,hrl_reply_to))
  {
    strcat(scm_comments," [RPTO:DUMP]");
    ret = 2;
  }

  if(test_field(dump_ll,hrl_xsender))
  {
    strcat(scm_comments," [XS:DUMP]");
    ret = 2;
  }

  if(test_field(dump_ll,hrl_ret_path))
  {
    strcat(scm_comments," [RETP:DUMP]");
    ret = 2;
  }

  if(test_field(dump_ll,hrl_cc))
  {
    strcat(scm_comments," [CC:DUMP]");
    ret = 2;
  }

  /*
   * check allows list and compare them to from and reply-to fields. if
   * either one match, then accept email.
   */
  if(test_field(allow_ll,hrl_from))
  {
    strcat(scm_comments," {FM:AL}");
    ret = 0;
  }

  if(test_field(allow_ll,hrl_reply_to))
  {
    strcat(scm_comments," {RPT:AL}");
    ret = 0;
  }

  /*
   * If somebody has sent an email with a from: entry of us, reject it.
   * (This is not overridden by an "allow:" entry)
   */
  if(test_field(me_ll,hrl_from))
  {
    strcat(scm_comments," [FM:ME]");
    ret = 2;
  }

  return ret;
}

void truncate_message(void)
{
  char *s;
  register int x;

  if(!truncation) return;

  print_log('I',"truncating message.");

  s = message_buf; 
  goto_message_body(&s);

  s += 2;
  for(x = 0;x < truncation;x++)
    if(s[x] == 0)
      return;
  s[x] = 0;
}

void upd_allow_deny(char *allow_deny,char *entry)
{
  FILE *fp;

  if((fp = fopen(allow_deny_file,"a")) != NULL)
  {
    fprintf(fp,"%s %s\n", allow_deny, entry);
    fclose(fp);
  }
}

void notify_exemption(void)
{
  FILE *fp_mail, *fp_ltr;
  char str[STR_LEN + 1];

  if(!emailable_addr[0])
    return;

  if(test_ll_2_str(me_ll,emailable_addr))
    return;

  strcpy(str,accept_letter);

  if((fp_ltr = fopen(str,"r")) == NULL)
    log_error("accept_letter()->fopen()");
  else
  {
    sprintf(str,"%s %s %s",sendmail_path, accept_from, emailable_addr);
    fp_mail = popen(str,"w");
    if(fp_mail != NULL)
    {
      print_log('I',"notifying exemption.");
      while(!feof(fp_ltr))
        if(fgets(str,STR_LEN,fp_ltr) != NULL)
          fputs(str,fp_mail);
      pclose(fp_mail);
      strcat(scm_comments," {EX-SNT}");
    }
  fclose(fp_ltr);
  }
}

int want_exemption(void)
{
  char str[STR_LEN + 1];

  if(test_ll_2_str(me_ll,emailable_addr))
    return 0;

  if(get_field(header_buf,hrl_subject,str,STR_LEN))
  {
    if(strstr(str,exemption_tok))
    {
      print_log('I',"sender exempted.");

      if(truncation)
      {
        truncate_message();
        sprintf(str," [TRUCT:%d]",truncation);
        strcat(scm_comments,str);
      }

      if(upd_allow_deny_f && *allow_deny_file && *emailable_addr)
      {
        upd_allow_deny("allow:", emailable_addr);
        notify_exemption();
      }
      return 1;
    }
  }
  return 0;
}

/****************************************************************************
*
****************************************************************************/
void notify_spammer(void)
{
  FILE *fp_mail, *fp_ltr;
  char str[STR_LEN + 1];

  if(!emailable_addr[0])
    return;

  if(test_ll_2_str(me_ll,emailable_addr))
    return;

  strcpy(str,reject_letter);

  if((fp_ltr = fopen(str,"r")) == NULL)
    log_error("reject_letter()->fopen()");
  else
  {
    sprintf(str,"%s %s %s",sendmail_path, reject_from, emailable_addr);
    fp_mail = popen(str,"w");
    if(fp_mail != NULL)
    {
      print_log('I',"notifying spammer.");
      while(!feof(fp_ltr))
        if(fgets(str,STR_LEN,fp_ltr) != NULL)
          fputs(str,fp_mail);

      pclose(fp_mail);
      strcat(scm_comments," {SNT}");

      // Prevent another notification being sent.
      if(*allow_deny_file && *emailable_addr)
        upd_allow_deny("dump:", emailable_addr);

    }
  fclose(fp_ltr);
  }
}

void save_spam(void)
{
  FILE *fp;
  char str[STR_LEN + 1];

  print_log('I',"saving spam.");

  append_line(&message_buf);

  strcpy(str,home_dir);
  strcat(str,"/mail/spam.rejected");
  fp = fopen(str,"a");
  if(fp == NULL)
  {
    perror("screen_message()->fopen()");
    return;
  }
  fputs(message_buf,fp);
  fputc('\n',fp);
  fclose(fp);
}

void pipe_to_procmail(void)
{
  FILE *fp;
  char cmdln[1024];
  register int x;

  print_log('I',"sending email to procmail.");

  append_line(&message_buf);

  strcpy(cmdln,procmail_path);
  for(x = 1;x < cmdc;x++)
  {
    strcat(cmdln," ");
    strcat(cmdln,cmdv[x]);
    x++;
  }

  fp = popen(cmdln,"w");
  if(fp == NULL)
    perror("pipe_to_procmail()->popen()");
  else
  {
    fputs(message_buf,fp);
    pclose(fp);
  }
}

/****************************************************************************
*
****************************************************************************/
int main(int argc,char *argv[])
{
  cmdc = argc;
  cmdv = argv;

  init();
  print_log('I',"--Starting-------------------------");
  load_conf();

  print_log('I',"recieving/converting message.");
  stream_2_buf(stdin,&message_buf);
  if(message_buf == NULL)
    return -1;
  convert_header();

  if(filter_f)
  {
    print_log('I',"Filtering.");

    switch(screen_header())
    {
      case 0: pipe_to_procmail();
              break;

      case 1: if(want_exemption())
                pipe_to_procmail();
              else
              {
                if(notify_f)
                  notify_spammer();
                if(save_spam_f)
                  save_spam();
              }
              break;

      case 2: if(want_exemption())
                pipe_to_procmail();
              else
              {
                if(save_spam_f)
                  save_spam();
              }
              break;

    }
  }
  else
  {
    print_log('I',"No Filtering (scan only).");

    screen_header();
    strcat(scm_comments," [!F]");
    pipe_to_procmail();
  }

  return 0;
}
