/****************************************************************************
* SCM Vn 2.0  April 2004
* Developed by Mike Eggleston (Fenland Software Ltd) from
*
*        spam mail counter-measure (SCM Vn 1.4)
*        By Jason Nunn <jsno@downunder.net.au>, May 2000
*        Darwin, NT, Australia
*
* Copyright (c) 2000  Jason Dunn
* Additional Code Copyright (c) 2004 Fenland Software Ltd 
*****************************************************************************
* logger
*
* log atoms
*
* E: = error
* W: = Warning
* I: = Information
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "scm.h"

char home_dir[STR_LEN + 1];
int  print_log_f = 0;

void print_log(char type,char *entry)
{
  FILE *fp;
  char str[STR_LEN];
  int pid;

  if(!print_log_f)
    return;

  pid = getpid();
  sprintf(str,"%s/mail/scm.log.%d",home_dir,pid);
  if((fp = fopen(str,"a")) != NULL)
  {
    fprintf(fp,"[%04d] %c: %s\n",pid,type,entry);
    fclose(fp);
  }
}

void log_error(char *msg)
{
  char str[STR_LEN];

  sprintf(str,"%s: %s",msg,strerror(errno));
  print_log('E',str);
}

void fatal_malloc_error(void)
{
  print_log('E',"Fatal malloc() error. Unable to alloc memory. Aborting.");
  exit(-1);
}
