/*

    subs.c  -  subroutines for makeSIGN

    Copyright (C) 1999  Christian Garbs   <mitch@uni.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


*/

/* ########################################################################### */
/*  Unterroutinen */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "boolean.h"
#include "string.h"
#include "global.h"
#include "types.h"
#include "vars.h"
#include "subs.h"

void show_error(s,returncode)
char *s;
BOOLEAN returncode;
//* Gibt eine Fehlermeldung aus
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"show_error() begin\n");
#endif

	if (error) {
		fprintf(stderr,"\n%s\n\n",s);
		fprintf(stderr,"%s v%s (%s %s)\n",PROGRAMM,VERSION,TXT_COMPILED_ON,VOM);
		fprintf(stderr,"%s\n",TXT_ENDING_ABNORMAL);
	};
	fflush(stdout);
	fflush(stderr);
	exit(returncode);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"show_error() end\n");
#endif

};
//* show_error



void show_info(s,b)
char *s;
BOOLEAN b;
//* Gibt eine Statusmeldung aus, wenn das erwnscht ist (info=true)
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"show_info() begin\n");
#endif

	if (info) {
		fprintf(stdout,"%s",s);
		if (b) {
			fprintf(stdout,"\n");
		};
	};
	fflush(stdout);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"show_info() end\n");
#endif

};
//* show_info


void open_reset(f,s1,s2)
//* ffnet eine Datei zum Lesen
FILE **f;
char *s1,*s2;
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"open_reset() begin\n");
#endif
	
	strcpy(text,s2);
	if (equal(s1,STDIO)) {
		*f=stdin;
	} else {
		*f=fopen(s1,"r");
		if (*f==NULL) {
			strcat(text,"..");
			strcat(text,TXT_ERROR);
			strcat(text,"!");
			show_error(text,RC_FILE_NOREAD);
		};
	};
	strcat(text,"..");
	strcat(text,TXT_OK);
	show_info(text,TRUE);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"open_reset(%d) end\n",(int)*f);
#endif

};
//* open_reset



void open_rewrite(f,s1,s2)
//* ffnet eine Datei zum Schreiben
FILE **f;
char *s1,*s2;
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"open_rewrite() begin\n");
#endif

	strcpy(text,s2);
	if (equal(s1,STDIO)) {
		*f=stdout;
	} else {
		*f=fopen(s1,"w");
		if (*f==NULL)
		{
			strcat(text,"..");
			strcat(text,TXT_ERROR);
			strcat(text,"!");
			show_error(text,RC_FILE_NOWRITE);
		};
	};
	strcat(text,"..");
	strcat(text,TXT_OK);
	show_info(text,TRUE);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"open_rewrite() end\n");
#endif

};
//* open_rewrite



void close_file(f,s)
//* Schliet eine Datei
FILE *f;
char *s;
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"close_file() begin\n");
#endif

	strcpy(text,s);
	if (!equal(s,STDIO)) {
		if (fclose(f) != 0) {
			strcat(text,"..");
			strcat(text,TXT_ERROR);
			strcat(text,"!");
			show_error(text,RC_FILE_NOCLOSE);
		};
	};
	strcat(text,"..");
	strcat(text,TXT_OK);
	show_info(text,TRUE);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"close_file() end\n");
#endif

};
//* close_file



void read_quote_header(f,replace,header_file,footer_file)
FILE *f;
BOOLEAN replace;
char **header_file;
char **footer_file;
//* Lesen des Headers einer Quote-Datei
{
	char *command,*value,*dummy;

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"read_quote_header(%d) begin\n",(int)f);
#endif
	
	zeile_lesen(f,&s);
	while ((s!=NULL) && (!equal(s,EMPTY))) {
		divide(s,&command,&value,"=");
		upper(command,&dummy);
		free(command);
		command=dummy;
		if ((equal(command,"HEADER")) && (replace)) {
			free(*header_file);
			stringcopy(value,header_file);
		};
		if ((equal(command,"FOOTER")) && (replace)) {
			free(*footer_file);
			stringcopy(value,footer_file);
		};
		free(command);
		free(value);
		free(s);
		zeile_lesen(f,&s);
	};
	free(s);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"read_quote_header() end\n");
#endif

};
//* read_quote_header



void reset_file(f)
//* Setzt eine Dateizeiger an den Dateianfang zurck
FILE *f;
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"reset_file() begin\n");
#endif

	fseek(f,0,0);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"reset_file() end\n");
#endif

};
//* reset_file



unsigned char input_file_number(long int counter)
//* Bestimmen der Dateinummer eines Quotes

{
	unsigned char cnt;

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"input_file_number() begin\n");
#endif

	for(cnt=1;counter>=input_file_start[cnt+1];cnt++);

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"input_file_number() end\n");
#endif

	return(cnt);

};
//* input_file_number



void debug(s,cnt)
char *s;
unsigned char cnt;
//* Ausgabe debug-Informationen

{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"debug() begin\n");
#endif

	fprintf(stderr,"%s\nCounter : %ld  quote_lines : %d",s,counter,quote_lines);
	fprintf(stderr,"  i_f_count : %d  i_f_strict_cnt : %d",input_file_count,input_file_strict_cnt);
	if (cnt<INFILES_MAX) {
		fprintf(stderr,"  cnt : %d  i_f_header[] : %s",cnt,input_file_header[cnt]);
		fprintf(stderr,"  i_f_header_lines_[] : %d  i_f_min_lines[] : %d",input_file_header_lines[cnt],input_file_min_lines[cnt]);
	};
	fprintf(stderr,"\n");
	getchar();

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"debug() end\n");
#endif

};
//* debug


BOOLEAN is_control_line(char *s)
//* Prft, ob die bergebene Zeile eine Kontrollzeile ist (z. B. [++] oder [----])
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"is_control_line() begin\n");
	depth--;
#endif

	return ((strlen(s)<7) && (s[0]=='[') && (s[strlen(s)-1]==']'));

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"is_control_line() end\n");
#endif
	
};
//* is_control_line



unsigned long int random_zahl(unsigned long int anzahl)
//* Gibt eine Zufallszahl zwischen 0 und anzahl aus
{

#ifdef DEBUG_SUBS
	depth++;
	debug_spaces();
	fprintf(stderr,"random_zahl() begin\n");
#endif

#ifdef DEBUG_SUBS
	debug_spaces();
	depth--;
	fprintf(stderr,"random_zahl() end\n");
#endif

	return (int long) (((double) rand() / RAND_MAX) * anzahl);

};
//* random_zahl



void debug_spaces ()
//* Rckt die Debuginformationen ein bzw. aus
{
	unsigned char i;
	
	if (depth>0) {
		for (i=0;i<=depth;i++) {
			fprintf(stderr," ");
		};
	};

};
//* debug_spaces
