/*

    string.c  -  a toolbox for string operations

    Copyright (C) 1999  Christian Garbs   <mitch@uni.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


*/

/*###########################################################################*/
/* Stringverarbeitungs-Routinen */

#include <stdio.h>
#include <malloc.h>
#include <ctype.h>

#include "subs.h"
#include "boolean.h"
#include "global.h"
#include "string.h"

extern char speicher_voll;	//* fr zeile_lesen()
#ifdef DEBUG_STRING
extern unsigned char depth;	//* zum Debuggen
#endif

//* Kopiert einen String in einen anderen
//* Im Gegensatz zu strcpy() wird der Zielstring dynamisch angelegt
void stringcopy(s,rueck)
char *s;
char **rueck;
{
	char *temp;

#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"stringcopy() begin\n");
#endif

	if (s!=NULL) {
		temp=(char *) malloc(strlen(s)+1);
		*rueck=strcpy(temp,s);
	} else {
		*rueck=NULL;
	};

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"stringcopy() end\n");
#endif

};

//* Gibt das erste Vorkommen eines Strings in einem String zurck
unsigned int instr(s,c)
char *s;
char *c;
{
	unsigned char p=0,p2;
	BOOLEAN found=FALSE;
	
#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"instr() begin\n");
#endif

	found=FALSE;
	do {
		if (s[p]==c[0]) {
			found=TRUE;
			if (strlen(c)>1) {
				for(p2=1;p2<strlen(c);p2++) {
					if (s[p+p2]!=c[p2]) {
						found=FALSE;
					};
				};
			};
		};
		p++;
	} while((found==FALSE) && (p<=strlen(s)));
	
#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"instr() end\n");
#endif

	if (found==TRUE) {
		return(p);
	} else {
		return(0);
	};

};

//* Gibt die ersten c Zeichen eines Strings zurck
void left(s,c,rueck)
char *s;
char c;
char **rueck;
{
	unsigned char p;
	char *temp;
	
#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"left() begin\n");
#endif

	if (c==0) {
		temp=NULL;
	} else {
		if (c>strlen(s)) {
			c=strlen(s);
		}
		temp=(char *) malloc(strlen(s)+1);
		for(p=0;p<c;p++) {
			temp[p]=s[p];
		};
		temp[p]=0;
	};
	stringcopy(temp,rueck);
	free(temp);

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"left() end\n");
#endif

};

//* Gibt die Zeichen ab der c. Stelle zurck
void right(s,c,rueck)
char *s;
char c;
char **rueck;
{
	char *temp;
        unsigned char p;
        
#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"right() begin\n");
#endif

        if (c>strlen(s)) {
                temp=NULL;
        } else {
                temp=(char *) malloc(strlen(s)-c+1);
                for (p=0;p<=strlen(s)-c;p++) {
			temp[p]=s[p+c];
		};
	};
	stringcopy(temp,rueck);
	free(temp);

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"right() end\n");
#endif

};

//* Wandelt String in Grobuchstaben um
void upper(s,rueck)
char *s;
char **rueck;
{
        unsigned char c;
        char *temp;
 
#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"upper() begin\n");
#endif

        stringcopy(s,&temp);
        if (strlen(s)>0) {
                for (c=0;c<=strlen(s);c++) {
                        temp[c]=toupper(temp[c]);
                };
        };
        stringcopy(temp,rueck);
        free(temp);

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"upper() end\n");
#endif

};

//* Teile einen String in zwei Substrings
void divide(string,begin,end,trennung)
char *string;
char **begin;
char **end;
char *trennung;
{

#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"divide() begin\n");
#endif

	if (string!=NULL) {
		switch(instr(string,trennung)) {
			case 0:	
				*end=NULL;
				stringcopy(string,begin);
				break;
				
			case 1:
				*begin=NULL;
				right(string,strlen(trennung),end);
				break;
			
			default:
				left(string,instr(string,trennung)-1,begin);
				right(string,instr(string,trennung)-1+strlen(trennung),end);
		};
	} else {
		*begin=NULL;
		*end=NULL;
	};

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"divide() end\n");
#endif

};

//* Umwandeln einer Char-Zahl in einen String  -  ehemals strng()
void char2string(c,rueck)
char c;
char **rueck;
{

	char temp[255];
	
#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"char2string() begin\n");
#endif

	sprintf(temp,"%d",c);
	stringcopy(temp,rueck);
	free(temp);

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"char2string() end\n");
#endif

};

//* Vergleich zweier Strings auf Gleichheit
BOOLEAN equal(s1,s2)
char *s1;
char *s2;
{

#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"equal() begin\n");
#endif
	
	if (s1==NULL) {
		if (s2==NULL) {

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"equal() end\n");
#endif
			return(TRUE);
		};
	} else {
		if (s2!=NULL) {
			if (strcmp(s1,s2)==0) {

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"equal() end\n");
#endif
				return(TRUE);
			};
		};
	};

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"equal() end\n");
#endif

	return(FALSE);

};



void zeile_lesen(datei,rueck)
FILE *datei;
char **rueck;
//* Liest eine Zeile aus einer Datei
{
	char *string;
	char *puffer;
	char *ende;
	char *zeile;
	size_t laenge;
	unsigned int pos;
	int c;

#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"zeile_lesen() begin\n");
#endif

	if ( FEHLER ) {
		zeile = NULL;
	}

	laenge = STANDARDZEILENLAENGE;
	puffer = (char *) malloc(laenge);
	string = puffer;
	ende = puffer + laenge -1;
	pos = 0;

	while ( ( c = getc (datei)) != '\n' && c != EOF ) {
		*string++ = c;
		pos++;
		if (string == ende) {
			laenge++;
			puffer = (char *) realloc(puffer, laenge);
			string = puffer + pos;
			ende = puffer + laenge -1;
		};
	};
	*string = '\0';

	if ( c == EOF && string == puffer ) {
		zeile = NULL;
	} else {
		zeile = (char*) malloc( string-puffer+1 );
		if ( zeile != NULL ) {
			strcpy ( zeile, puffer );
		} else {
			zeile = puffer;
			speicher_voll = TRUE;
		};
	};

	free(puffer);
	stringcopy(zeile,rueck);
	if (FEHLER) {
		show_error(ERROR_MEMORY_FULL,RC_MEMORY_FULL);
	};

#ifdef DEBUG_INPUT
	printf("%s\n",zeile);
#endif
	
#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"zeile_lesen() end\n");
#endif

};
//* zeile_lesen



void zeile_schreiben(datei,s,nl)
FILE *datei;
char *s;
BOOLEAN nl;
//* Gibt eine Zeile in eine Datei aus
{

#ifdef DEBUG_STRING
	depth++;
	debug_spaces();
	fprintf(stderr,"zeile_schreiben() begin\n");
#endif

	if (nl==TRUE) {
		fprintf(datei,"%s\n",s);
	} else {
		fprintf(datei,"%s",s);
	};

#ifdef DEBUG_STRING
	debug_spaces();
	depth--;
	fprintf(stderr,"zeile_schreiben() end\n");
#endif

};
//* zeile_schreiben
