/*

    parts.c  -  main program parts of makeSIGN

    Copyright (C) 1999  Christian Garbs   <mitch@uni.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


*/

//###########################################################################}
// Hauptprogrammteile

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <time.h>

#include "boolean.h"
#include "string.h"
#include "global.h"
#include "types.h"
#include "vars.h"
#include "subs.h"
#include "parts.h"

void alternative_header_footer(void)
//* HEADER und FOOTER aus infile benutzen
{
	unsigned char cnt;
	
#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"alternative_header_footer() begin\n");
#endif

	cnt=input_file_number(counter);
	sprintf(text,"%s #%d \"%s\"",TXT_OPEN_INPUTFILE,cnt,input_file[cnt]); 	
	open_reset(&ein,input_file[cnt],text);
	sprintf(text,"%s..",TXT_LOOK_FOR_ALT);
	show_info(text,FALSE); 	
	read_quote_header(ein,!override,&header_file,&footer_file); 	
	show_info("OK",TRUE);
	sprintf(text,"%s #%d \"%s\"",TXT_CLOSE_INPUTFILE,cnt,input_file[cnt]);
	close_file(ein,text);
	if((strict) && (input_file_header_lines[cnt]+quote_lines>LINES_MAX)) {
		header_file=EMPTY;
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"alternative_header_footer() end\n");
#endif

};
//* alternative_header_footer



void close_outputfile(void)
//* Schlieen outfile
{

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"close_outputfile() begin\n");
#endif

	if (equal(output_file,STDIO)) {
		sprintf(text,"%s <STDOUT> ..OK",TXT_CLOSE_SIGFILE);
		show_info(text,TRUE);
	} else {
		sprintf(text,"%s \"%s\" ",TXT_CLOSE_SIGFILE,output_file);
		close_file(aus,text);
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"close_outputfile() end\n");
#endif

};
//* close_outputfile



void copy_quote(void)
//* Quote kopieren (infile->outfile)
{
        unsigned char cnt;
        unsigned long int pos;

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"copy_quote() begin\n");
#endif

	cnt=input_file_number(counter);
	sprintf(text,"%s #%d \"%s\" ",TXT_OPEN_INPUTFILE,cnt,input_file[cnt]);
	open_reset(&ein,input_file[cnt],text);
	pos=input_file_start[cnt];
	sprintf(text,"%s..",TXT_COPY_QUOTE);
	show_info(text,FALSE);
	read_quote_header(ein,FALSE,&header_file,&footer_file);
	zeile_lesen(ein,&s);
	while ((pos<counter) && (s!=NULL)) {
		free(s);
		zeile_lesen(ein,&s);
		if (!equal(s,EMPTY)) {
			while ((!equal(s,EMPTY)) && (s!=NULL)) {
				free(s);
				zeile_lesen(ein,&s);
			};
			pos++;
		};
	};
	while ((equal(s,EMPTY)) && (s!=NULL)) {
		free(s);
		zeile_lesen(ein,&s);
	};
	if (is_control_line(s)) {
		free(s);
		zeile_lesen(ein,&s);
	};
	while ((!equal(s,EMPTY)) && (s!=NULL)) {
		zeile_schreiben(aus,s,TRUE);
		lines_used++;
		free(s);
		zeile_lesen(ein,&s);
	};
	show_info("OK",TRUE);
	sprintf(text,"%s #%d \"%s\" ",TXT_CLOSE_INPUTFILE,cnt,input_file[cnt]);
	close_file(ein,text);
	tlist_destruct(list);
	free(s);

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"copy_quote() end\n");
#endif

};
//* copy_quote



void index_quotes(void)
//* Quote-Dateien indizieren
{
	unsigned char cnt,min_lines_strict=0,std_header_lines=0;
	PLISTCONTENT data;
	char *dummy,*dummy2,*dummy3;
	FILE *header;
	
#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"index_quotes() begin\n");
#endif

	if (strict) {
		std_header_lines=0;
		if (equal(header_file,STDIO)) {
			show_error(ERROR_STRICT_HEADER,RC_STRICT_HEADER);
		};
		if (!equal(header_file,EMPTY)) {
			sprintf(text,"STRICT: %s \"%s\" ",TXT_OPEN_HEADERFILE,header_file);
			open_reset(&header,header_file,text);
			sprintf(text,"STRICT: %s..",TXT_READ_HEADERLENGTH);
			show_info(text,FALSE);
			zeile_lesen(header,&s);
			while (s!=NULL) {
				free(s);
				zeile_lesen(header,&s);
				std_header_lines++;
			};
			free(s);
			show_info("OK",TRUE);
			sprintf(text,"STRICT: %s \"%s\" ",TXT_CLOSE_HEADERFILE,header_file);
			close_file(header,text);
		};
	};
	list=tlist_construct();
	counter=1;
	for(cnt=1;cnt<=input_file_count;cnt++) {
		sprintf(text,"%s #%d \"%s\" ",TXT_OPEN_INPUTFILE,cnt,input_file[cnt]);
		open_reset(&ein,input_file[cnt],text);
		input_file_start[cnt]=counter;
		sprintf(text,"%s..",TXT_INDEX_QUOTES);
		show_info(text,FALSE);
		if (strict) {
			stringcopy(header_file,&input_file_header[cnt]);
			dummy=NULL;
			read_quote_header(ein,TRUE,&input_file_header[cnt],&dummy);
			free(dummy);
			if (equal(input_file_header[cnt],STDIO)) {
				show_error(ERROR_STRICT_HEADER,RC_STRICT_HEADER);
			};
			min_lines_strict=LINES_MAX+1;
			if (equal(input_file_header[cnt],header_file)) {
				input_file_header_lines[cnt]=std_header_lines;
			} else {
				sprintf(text,"STRICT: %s \"%s\" ",TXT_OPEN_HEADERFILE,input_file_header[cnt]);
				open_reset(&header,input_file_header[cnt],text);
				show_info(TXT_READ_HEADERLENGTH,FALSE);
				input_file_header_lines[cnt]=0;
				zeile_lesen(header,&s);
				while (s!=NULL) {
					free(s);
					zeile_lesen(header,&s);
					input_file_header_lines[cnt]++;
				};
				free(s);
				show_info(" OK",TRUE);
				sprintf(text,"STRICT: %s \"%s\" ",TXT_CLOSE_HEADERFILE,input_file_header[cnt]);
				close_file(header,text);
			};
		} else {
			read_quote_header(ein,FALSE,&header_file,&footer_file);
		};
		zeile_lesen(ein,&s);
		while (s!=NULL) {
			if (!equal(s,EMPTY)) {
				data=(PLISTCONTENT) malloc(sizeof(TLISTCONTENT));
				if (data==NULL)	{
					show_error(ERROR_MEMORY_FULL,RC_MEMORY_FULL);
				};
				data->p=50;
				if (is_control_line(s)) {
					dummy=s+1;
					while (dummy[0]!=']') {
						if ((dummy[0]=='+') && (data->p<90)) {
							data->p+=10;
						};
						if ((dummy[0]=='-') && (data->p>10)) {
							data->p-=10;
						};
						dummy++;
					};
					if (equality) {
						data->p=50;
					};
					free(s);
					zeile_lesen(ein,&s);
				};
				data->lines=2;
				free(s);
				zeile_lesen(ein,&s);
				while ((!equal(s,EMPTY)) && (s!=NULL)) {
					free(s);
					zeile_lesen(ein,&s);
					data->lines++;
				};
				if (equal(s,EMPTY)) {
					data->lines--;
				};
				tlist_go_end(list);
				tlist_new(list);
				tlist_put(list,data);
				if ((strict) && (data->lines < min_lines_strict)) {
					min_lines_strict=data->lines;
				};
				if (data->lines < min_lines) {
					min_lines=data->lines;
				};
				counter++;
			};
			free(s);
			zeile_lesen(ein,&s);
		};
		if (strict) {
			input_file_min_lines[cnt]=min_lines_strict;
			if (input_file_header_lines[cnt]+min_lines_strict <= LINES_MAX) {
				input_file_strict_cnt++;
			};
		};
		show_info("OK",TRUE);
		sprintf(text,"%s #%d \"%s\" ",TXT_CLOSE_INPUTFILE,cnt,input_file[cnt]);
		close_file(ein,text);
         	if (strict) {
			input_file_min_lines[cnt]=min_lines_strict;
		};
	};
	if (min_lines>LINES_MAX) {
		stringcopy(ERROR_MORE_THAN_LINMAX,&dummy);
		divide(dummy,&dummy2,&dummy3,"$LINES_MAX$");
		sprintf(text,"STRICT: %s%d%s",dummy2,LINES_MAX,dummy3);
		free(dummy);
		free(dummy2);
		free(dummy3);
		show_error(text,RC_MORE_THAN_LINMAX);
	};
	for (cnt=input_file_count+1;cnt<=INFILES_MAX+1;cnt++) {
		input_file_start[cnt]=counter;
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"index_quotes() end\n");
#endif

};
//* index_quotes



void init_program(void)
//* Programmstart: Die Konstanten werden den Variablen zugewiesen
{
	error=STD_ERROR;
	info=STD_INFO;
	stdins=0;
	override=STD_OVERRIDE;
	equality=STD_EQUAL;
	strict=STD_STRICT;
	separator=STD_SEPARATOR;

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"init_program() begin\n");
#endif

	srand((unsigned)time(NULL));
        /* Warum mu hier ein rand() hin ?!?!?
           Ohne gibt es IMMER dieselbe Zahl beim 1. Aufruf */
        rand();
	lines_used=0;
	stringcopy(STD_FOOTER_FILE,&footer_file);
	stringcopy(STD_HEADER_FILE,&header_file);
	stringcopy(STD_OUTPUT_FILE,&output_file);
	for(c=1;c<=INFILES_MAX;c++) {
		stringcopy(EMPTY,&input_file[c]);
	};
	input_file_count=0;
	input_file_strict_cnt=0;
	min_lines=INFILES_MAX+1;
	sprintf(text,"%s v%s (%s %s)",PROGRAMM,VERSION,TXT_COMPILED_ON,VOM);
	show_info(text,TRUE);
	sprintf(text,"%s %s <%s>",COPYRIGHT,AUTOR,EMAIL);
	show_info(text,TRUE);
	show_info(EMPTY,TRUE);

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"init_program() end\n");
#endif

};
//* init



void open_outputfile(void)
//* ffnen outfile
{

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"open_outputfile() begin\n");
#endif

	if (equal(output_file,STDIO)) {
		sprintf(text,"%s <STDOUT>",TXT_OPEN_SIGFILE);
		open_rewrite(&aus,STDIO,text);
	} else {
		sprintf(text,"%s \"%s\" ",TXT_OPEN_SIGFILE,output_file);
		open_rewrite(&aus,output_file,text);
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"open_outputfile() end\n");
#endif

};
//* open_outputfile



void pick_quote(void)
//* Aussuchen des Quotes
{
	unsigned long int cnt;
	PLISTCONTENT data;
	
#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"pick_quote() begin\n");
#endif

	sprintf(text,"%s..",TXT_PICK_QUOTE);
	show_info(text,FALSE);
	do {
		counter=random_zahl(tlist_length(list)+1);
		tlist_go_begin(list);
		cnt=1;
		while (cnt<counter) {
			tlist_next(list);
			cnt++;
		};
		data=tlist_get(list);
		if (strict) {
			quote_lines=data->lines;
			if (input_file_strict_cnt>0) {
				if (data->lines + input_file_header_lines[input_file_number(counter)] > LINES_MAX) {
					data->p=0;
				};
			} else {
				if (data->lines > LINES_MAX) {
					data->p=0;
				};
			};
		};
	} while (random_zahl(100)>=data->p);
	show_info("OK",TRUE);

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"pick_quote() end\n");
#endif

};
//* pick_quote



BOOLEAN proc_commandline(argc,argv)
//* Verarbeiten der Kommandozeilenparameter
int argc;
char *argv[];
{
	BOOLEAN process_params=TRUE;
	unsigned char cnt;
	BOOLEAN parsed;
	char *p,*dummy1,*dummy2,*dummy3;

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"proc_commandline() begin\n");
#endif

	show_info(TXT_USE_CMDLINE,TRUE);
	cnt=1;
	while ((cnt<argc) && (argv[cnt][0]=='-') && (!equal(argv[cnt],STDIO))) {
		if (argv[cnt][1]=='-') {
			// langes Argument
			upper(argv[cnt],&p);
			parsed=FALSE;
			p+=2;
			if (equal(p,"QUIET")) {
				error=FALSE;
				info=FALSE;
				parsed=TRUE;
			};
			if (equal(p,"VERBOSE")) {
				error=TRUE;
				info=TRUE;
				parsed=TRUE;
			};
			if (equal(p,"STRICT")) {
				strict=TRUE;
				parsed=TRUE;
			};
			if (equal(p,"OVERRIDE")) {
				override=TRUE;
				parsed=TRUE;
			};
			if (equal(p,"EQUAL")) {
				equality=TRUE;
				parsed=TRUE;
			};
			if (equal(p,"SEPARATOR")) {
				separator=TRUE;
				parsed=TRUE;
			};
			if (equal(p,"HELP")) {
				cnt=argc;
				process_params=FALSE;
				help=TRUE;
				parsed=TRUE;
			};
			if (equal(p,"HEADER")) {
				cnt++;
				free(header_file);
				stringcopy(argv[cnt],&header_file);
				if (equal(header_file,STDIO)) {
					stdins++;
				};
				parsed=TRUE;
			};
			if (equal(p,"FOOTER")) {
				cnt++;
				free(footer_file);
				stringcopy(argv[cnt],&footer_file);
				if (equal(footer_file,STDIO)) {
					stdins++;
				};
				parsed=TRUE;
			};
			if (equal(p,"VERSION")) {
				cnt=argc;
				process_params=FALSE;
				help=FALSE;
				parsed=TRUE;
			};
			p-=2;
		} else {
			// kurzes Argument
			stringcopy(argv[cnt],&p);
			dummy1=p;
			parsed=TRUE;
			for(p++;p[0]!=0;p++) {
				switch (p[0]) {
				case 'q'://quiet
					error=FALSE;
					info=FALSE;
					break;
					
				case 'v'://verbose
					error=TRUE;
					info=TRUE;
					break;

				case 'S'://strict
					strict=TRUE;
					break;

				case 'o'://override
					override=TRUE;
					break;

				case 'e'://equal
					equality=TRUE;
					break;

				case 's'://separator
					separator=TRUE;
					break;

				case '?'://help
					cnt=argc;
					process_params=FALSE;
					help=TRUE;
					break;

				case 'V'://version
					cnt=argc;
					process_params=FALSE;
					help=FALSE;
					break;

				case 'h'://header
					free(header_file);
					if (p[1] != 0) { //direkt hintendran
						stringcopy(++p,&header_file);
					} else {
						cnt++;
						stringcopy(argv[cnt],&header_file);
					};
					if (equal(header_file,STDIO)) {
						stdins++;
					};
					break;

				case 'f'://footer
					free(footer_file);
					if (p[1] != 0) { //direkt hintendran
						stringcopy(++p,&footer_file);
					} else {
						cnt++;
						stringcopy(argv[cnt],&footer_file);
					};
					if (equal(footer_file,STDIO)) {
						stdins++;
					};
					break;

				default:
					parsed=FALSE;
				};
			};
			p=dummy1;
		};
		if (!parsed) {
			sprintf(text,"%s: %s",ERROR_UNKNOWN_CMDLINE,p);
			show_error(text,RC_UNKNOWN_CMDLINE);
		};
		cnt++;
		free(p);
	};
	if (stdins>1) {
		show_error(ERROR_TWO_STDINS,RC_TWO_STDINS);
	};
	if (process_params && cnt<argc) {
		stringcopy(argv[cnt],&output_file);
		cnt++;
		while (cnt<argc) {
			input_file_count++;
			if (input_file_count>INFILES_MAX) {
				stringcopy(ERROR_MORE_THAN_INFMAX,&dummy1);
				divide(dummy1,&dummy2,&dummy3,"$INFILES_MAX$");
				sprintf(text,"%s%d%s",dummy2,INFILES_MAX,dummy3);
				free(dummy1);
				free(dummy2);
				free(dummy3);
				show_error(text,RC_MORE_THAN_INFMAX);
			};
			free(input_file[input_file_count]);
			stringcopy(argv[cnt],&input_file[input_file_count]);
			cnt++;
		};
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"proc_commandline() end\n");
#endif

	return process_params;

};
//* proc_commandline



BOOLEAN proc_configfile(argc,argv)
//* Verarbeiten der Konfigurationsdatei
int argc;
char *argv[];
{
	BOOLEAN process_params=TRUE,parsed;
	char *config_file,*line,*command,*value,*dummy,*dummy2,*dummy3;
	
#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"proc_configfile() begin\n");
#endif

	upper(argv[1],&dummy);
	if (equal(dummy,"-?") || equal(dummy,"--HELP") || equal(dummy,"-V") || equal(dummy,"--VERSION")) {
		help=TRUE;
		process_params=FALSE;
	} else {
		stringcopy(argv[1],&config_file);
		show_info(TXT_USE_CONFIGFILE,TRUE);
		if (equal(config_file,STDIO)) {
			sprintf(text,"%s <STDIN> ",TXT_OPEN_CONFIGFILE);
			open_reset(&ein,STDIO,text);
		} else {
			sprintf(text,"%s \"%s\" ",TXT_OPEN_CONFIGFILE,config_file);
			open_reset(&ein,config_file,text);
		};
		zeile_lesen(ein,&line);
		while (line!=NULL) {
			divide(line,&command,&value,"=");
			upper(command,&s);
			free(command);
			command=s;
			parsed=FALSE;
			
			if (equal(command,"VERBOSE")) {
				upper(value,&s);
				if (equal(s,"YES") || equal(s,"TRUE")) {
					info=TRUE;
					error=TRUE;
				};
				free(s);
				parsed=TRUE;
			};
			
			if (equal(command,"QUIET")) {
				upper(value,&s);
				if (equal(s,"YES") || equal(s,"TRUE")) {
					info=FALSE;
					error=FALSE;
				};
				free(s);
				parsed=TRUE;
			};

			if (equal(command,"STRICT")) {
				upper(value,&s);
				if (equal(s,"YES") || equal(s,"TRUE")) {
					strict=TRUE;
				}
				else
				{
					strict=FALSE;
				};
				free(s);
				parsed=TRUE;
			};

			if (equal(command,"OVERRIDE")) {
				upper(value,&s);
				if (equal(s,"YES") || equal(s,"TRUE")) {
					override=TRUE;
				}
				else
				{
					override=FALSE;
				};
				free(s);
				parsed=TRUE;
			};

			if (equal(command,"EQUAL")) {
				upper(value,&s);
				if (equal(s,"YES") || equal(s,"TRUE")) {
					equality=TRUE;
				}
				else
				{
					equality=FALSE;
				};
				free(s);
				parsed=TRUE;
			};

			if (equal(command,"SEPARATOR")) {
				upper(value,&s);
				if (equal(s,"YES") || equal(s,"TRUE")) {
					separator=TRUE;
				}
				else
				{
					separator=FALSE;
				};
				free(s);
				parsed=TRUE;
			};

			if (equal(command,"HEADER")) {
				stringcopy(value,&header_file);
				parsed=TRUE;
			};

			if (equal(command,"FOOTER")) {
				stringcopy(value,&footer_file);
				parsed=TRUE;
			};
			
			if (equal(command,"INFILE")) {
				input_file_count++;
				if (input_file_count>INFILES_MAX) {
					stringcopy(ERROR_MORE_THAN_INFMAX,&dummy);
					divide(dummy,&dummy2,&dummy3,"$INFILES_MAX$");
					sprintf(text,"%s%d%s",dummy2,INFILES_MAX,dummy3);
					free(dummy);
					free(dummy2);
					free(dummy3);
					show_error(text,RC_MORE_THAN_INFMAX);
				};
				free(input_file[input_file_count]);
				stringcopy(value,&input_file[input_file_count]);
				parsed=TRUE;
			};
			
			if (equal(command,"OUTFILE")) {
				stringcopy(value,&output_file);
				parsed=TRUE;
			};

			if (!parsed && (line[0] != '#')) {
				sprintf(text,"%s: %s",ERROR_UNKNOWN_CFGLINE,line);
				show_error(text,RC_UNKNOWN_CFGLINE);
			};
			free(line);
			zeile_lesen(ein,&line);
		};
		free(line);
		if (equal(config_file,STDIO)) {
			sprintf(text,"%s <STDIN> ",TXT_CLOSE_CONFIGFILE);
			close_file(ein,text);
		} else {
			sprintf(text,"%s \"%s\" ",TXT_CLOSE_CONFIGFILE,config_file);
			close_file(ein,text);
		};
		if (input_file_count==0) {
			show_error(ERROR_NO_INPUTFILE,RC_NO_INPUTFILE);
		};
	};
	free(dummy);

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"proc_configfile() end\n");
#endif

	return process_params;

};
//* proc_configfile



BOOLEAN process_params(argc,argv)
//* bergebene Parameter auswerten
int argc;
char *argv[];
{
	
#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"process_params() begin\n");
#endif

	if (argc==1) {
		help=TRUE;
		return FALSE;
	} else {
		if (argc>2) {
			return proc_commandline(argc,argv);
		} else {
			return proc_configfile(argc,argv);
		}
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"process_params() end\n");
#endif

	return TRUE;

};
//* process_params



void show_help(void)
//* kurze Hilfe ausgeben
{

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"show_help() begin\n");
#endif

	info=TRUE;
	if (!equal(HELP_SCREEN_LINE1,EMPTY)) {
		show_info(HELP_SCREEN_LINE1,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE2,EMPTY)) {
		show_info(HELP_SCREEN_LINE2,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE3,EMPTY)) {
		show_info(HELP_SCREEN_LINE3,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE4,EMPTY)) {
		show_info(HELP_SCREEN_LINE4,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE5,EMPTY)) {
		show_info(HELP_SCREEN_LINE5,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE6,EMPTY)) {
		show_info(HELP_SCREEN_LINE6,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE7,EMPTY)) {
		show_info(HELP_SCREEN_LINE7,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE8,EMPTY)) {
		show_info(HELP_SCREEN_LINE8,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE9,EMPTY)) {
		show_info(HELP_SCREEN_LINE9,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE10,EMPTY)) {
		show_info(HELP_SCREEN_LINE10,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE11,EMPTY)) {
		show_info(HELP_SCREEN_LINE11,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE12,EMPTY)) {
		show_info(HELP_SCREEN_LINE12,TRUE);
	};
	if (!equal(HELP_SCREEN_LINE13,EMPTY)) {
		show_info(HELP_SCREEN_LINE13,TRUE);
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"show_help() end\n");
#endif

};
//* show_help



void stop_program(void)
//* Programmende
{


#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"stop_program() begin\n");
#endif

	if (!equal(output_file,STDIO)) {
		info=error;
	};
	show_info("",TRUE);
	sprintf(text,"%s v%s (%s %s)",PROGRAMM,VERSION,TXT_COMPILED_ON,VOM);
	show_info(text,TRUE);
	sprintf(text,"%s %s <%s>",COPYRIGHT,AUTOR,EMAIL);
	show_info(text,TRUE);
	sprintf(text,"%s: %s",TXT_CURRENT_VERSION,URL);
	show_info(text,TRUE);
	show_info(TXT_ENDING_NORMAL,TRUE);

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"show_program() end\n");
#endif

};
//* stop



void write_footer(void)
//* Schreiben FOOTER-Datei
{

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"write_footer() begin\n");
#endif

	if (equal(footer_file,STDIO)) {
		sprintf(text,"%s <STDIN> ",TXT_OPEN_FOOTERFILE);
		open_reset(&ein,STDIO,text);
		if (strict) {
			show_error(ERROR_STRICT_FOOTER,RC_STRICT_FOOTER);
		};
		sprintf(text,"%s..",TXT_WRITE_FOOTERFILE);
		show_info(text,FALSE);
		zeile_lesen(ein,&s);
		while (s!=NULL) {
			zeile_schreiben(aus,s,TRUE);
			free(s);
			zeile_lesen(ein,&s);		
		};
		free(s);
		show_info("OK",TRUE);
		sprintf(text,"%s <STDIN> ",TXT_CLOSE_FOOTERFILE);
		close_file(ein,text);
	} else {
		sprintf(text,"%s \"%s\" ",TXT_OPEN_FOOTERFILE,footer_file);
		open_reset(&ein,footer_file,text);
		if (strict) {
			sprintf(text,"STRICT: %s..",TXT_CHECK_FOOTERLENGTH);
			show_info(text,FALSE);
			zeile_lesen(ein,&s);
			while (s!=NULL) {
				lines_used++;
				free(s);
				zeile_lesen(ein,&s);
			};
			free(s);
			show_info("OK",TRUE);
			reset_file(ein);
			if (lines_used > LINES_MAX) {
				sprintf(text,"STRICT: %s",TXT_SKIP_FOOTERFILE);
				show_info(text,TRUE);
			};
		};
		if (lines_used <= LINES_MAX) {
			sprintf(text,"%s..",TXT_WRITE_FOOTERFILE);
			show_info(text,FALSE);
			zeile_lesen(ein,&s);
			while (s!=NULL) {
				zeile_schreiben(aus,s,TRUE);
				free(s);
				zeile_lesen(ein,&s);
			};
			free(s);
			show_info("OK",TRUE);
		};
		sprintf(text,"%s \"%s\" ",TXT_CLOSE_FOOTERFILE,footer_file);
		close_file(ein,text);
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"write_footer() end\n");
#endif

};
//* write_footer



void write_header(void)
//* Schreiben HEADER-Datei
{

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"write_header() begin\n");
#endif

	if (equal(header_file,STDIO)) {
		sprintf(text,"%s <STDIN> ",TXT_OPEN_HEADERFILE);
		open_reset(&ein,STDIO,text);
		if (strict) {
			show_error(ERROR_STRICT_HEADER,RC_STRICT_HEADER);
		};
		sprintf(text,"%s..",TXT_WRITE_HEADERFILE);
		show_info(text,FALSE);
		zeile_lesen(ein,&s);
		while (s!=NULL) {
			zeile_schreiben(aus,s,TRUE);
			free(s);
			zeile_lesen(ein,&s);
		};
		free(s);
		show_info("OK",TRUE);
		sprintf(text,"%s <STDIN> ",TXT_CLOSE_HEADERFILE);
		close_file(ein,text);
	} else {
		sprintf(text,"%s \"%s\" ",TXT_OPEN_HEADERFILE,header_file);
		open_reset(&ein,header_file,text);
		if (strict) {
			sprintf(text,"STRICT: %s..",TXT_CHECK_HEADERLENGTH);
			show_info(text,FALSE);
			zeile_lesen(ein,&s);
			while (s!=NULL) {
				free(s);
				lines_used++;
				zeile_lesen(ein,&s);
			};
			show_info("OK",TRUE);
			reset_file(ein);
			if (lines_used+input_file_min_lines[input_file_number(counter)] > LINES_MAX) {
				sprintf(text,"STRICT: %s",TXT_SKIP_HEADERFILE);
				show_info(text,TRUE);
			};
		};
		if (lines_used <= LINES_MAX) {
			sprintf(text,"%s..",TXT_WRITE_HEADERFILE);
			show_info(text,FALSE);
			zeile_lesen(ein,&s);
			while (s!=NULL) {
				zeile_schreiben(aus,s,TRUE);
				free(s);
				zeile_lesen(ein,&s);
			};
			free(s);
			show_info("OK",TRUE);
		} else {
			lines_used=0;
		};
		sprintf(text,"%s \"%s\" ",TXT_CLOSE_HEADERFILE,footer_file);
		close_file(ein,text);
	};

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"write_header() end\n");
#endif

};
//* write_header



void write_separator(void)
//* Schreiben Trennzeichen
{

#ifdef DEBUG_PARTS
	depth++;
	debug_spaces();
	fprintf(stderr,"write_separator() begin\n");
#endif

	sprintf(text,"%s \"-- \"..",TXT_WRITE_SEPARATOR);
	show_info(text,FALSE);
	zeile_schreiben(aus,"-- ",TRUE);
	show_info("OK",TRUE);

#ifdef DEBUG_PARTS
	debug_spaces();
	depth--;
	fprintf(stderr,"write_separator() end\n");
#endif

}
//* write_separator
