#ifndef MESSAGES_H_INCLUDED
#define MESSAGES_H_INCLUDED

//* makeSIGN Messages

//* Language:	en (english)
//* Author:	Christian Garbs <mitch@uni.de>
//* Date:	99-08-23
//* Version:    1.33.1

//* If you want makeSIGN to have native language support for YOUR
//* language, then edit this file and send it to <mitch@uni.de>
//* It will then be included within the next version of makeSIGN.

//* Be sure to make clean; make all if you change something in here.

//* Here you can get makeSIGN

#define URL        		"http://www.h.shuttle.de/mitch/download.html#makeSIGN"

//* These are status messages

#define	TXT_OPEN_INPUTFILE	"Opening input file"
#define TXT_OPEN_SIGFILE	"Opening signature file"
#define	TXT_OPEN_CONFIGFILE	"Opening config file"
#define TXT_OPEN_HEADERFILE	"Opening header file"
#define TXT_OPEN_FOOTERFILE	"Opening footer file"

#define TXT_CLOSE_INPUTFILE	"Closing input file"
#define TXT_CLOSE_SIGFILE	"Closing signature file"
#define	TXT_CLOSE_CONFIGFILE	"Closing config file"
#define TXT_CLOSE_HEADERFILE	"Closing header file"
#define TXT_CLOSE_FOOTERFILE	"Closing footer file"

#define TXT_COPY_QUOTE		"Copying quote"
#define TXT_INDEX_QUOTES	"Indexing quotes"
#define	TXT_PICK_QUOTE		"Picking random quote"

#define TXT_READ_HEADERLENGTH	"Reading length of header file"
#define	TXT_WRITE_HEADERFILE	"Writing header to signature"
#define	TXT_SKIP_HEADERFILE	"Skipping header (too long)"
#define	TXT_CHECK_HEADERLENGTH	"Checking length of header file"

#define	TXT_WRITE_FOOTERFILE	"Writing footer to signature"
#define	TXT_SKIP_FOOTERFILE	"Skipping footer (too long)"
#define	TXT_CHECK_FOOTERLENGTH	"Checking length of footer file"

#define TXT_LOOK_FOR_ALT	"Looking for alternative header/footer"
#define TXT_WRITE_SEPARATOR	"Writing Separator"

#define TXT_USE_CMDLINE		"Using commandline parameters"
#define	TXT_USE_CONFIGFILE	"Using configfile"

#define	TXT_ENDING_NORMAL	"normal program termination"
#define	TXT_ENDING_ABNORMAL	"abnormal program termination\ntry 'makesign -?' for help"

#define	TXT_OK			"OK"
#define	TXT_ERROR		"error"
#define	TXT_COMPILED_ON		"compiled on"
#define	TXT_CURRENT_VERSION	"up-to-date version"

//* These are error messages

#define ERROR_STRICT_HEADER	"STRICT cannot be used together with HEADER <STDIN>"
#define ERROR_STRICT_FOOTER	"STRICT cannot be used together with FOOTER <STDIN>"
#define	ERROR_MORE_THAN_LINMAX	"There are no quotes with $LINES_MAX$ or less lines"
#define	ERROR_TWO_STDINS	"HEADER and FOOTER can't be set to <STDIN> simultaneously"
#define	ERROR_UNKNOWN_CMDLINE	"Unknown commandline parameter"
#define	ERROR_UNKNOWN_CFGLINE	"Unknown command in configuration file"
#define	ERROR_MORE_THAN_INFMAX	"You cannot use more than $INFILES_MAX$ motto files"
#define	ERROR_NO_INPUTFILE	"No inputfile given in config file"
#define	ERROR_MEMORY_FULL	"Not enough memory to complete operation"

//* This is the help page that is printed when no options are given.
//* Note: Blank lines will not be printed.

#define	HELP_SCREEN_LINE1	"USAGE:"
#define	HELP_SCREEN_LINE2	"makesign [-?SVeoqsv] [-f FOOTERFILE] [-h HEADERFILE] [--help]"
#define	HELP_SCREEN_LINE3	"         [--strict] [--version] [--equal] [--override] [--quiet]"
#define	HELP_SCREEN_LINE4	"         [--separator] [--verbose] [--footer FOOTERFILE] [--header"
#define	HELP_SCREEN_LINE5	"         HEADERFILE] outfile infile_1 [infile_2 ... infile_20]"
#define	HELP_SCREEN_LINE6	"or"
#define	HELP_SCREEN_LINE7	"makesign configurationfile"
#define	HELP_SCREEN_LINE8	""
#define	HELP_SCREEN_LINE9	""
#define	HELP_SCREEN_LINE10	""
#define	HELP_SCREEN_LINE11	""
#define	HELP_SCREEN_LINE12	""
#define	HELP_SCREEN_LINE13	""

#endif
