/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_FCNTL
#define IS_STAT
#define IS_STDIO
#define IS_STRING
#define IS_TYPES
#define IS_UNISTD

#include "config.h"
#include "includes.h"
#include "prototypes.h"

/* This routine checks if the emailaddr matches the user at host
 * name given.  I'm sure there are still valid email address formats
 * that this routine can't recognize.  i.e. Such as DEC mail.
 */

int usercmp(char *emailaddr,char *user,char *host){
  int i,j;
  char ex[LINESIZE];
  static char *start[2]={"^[<]*","[:!]"};
  static char *end[2]={"[.:@!]","[>]*$"};

#ifdef DEBUG
  fprintf(fstdio[1],"usercmp %s %s %s\n",emailaddr,user,host);
  fflush(fstdio[1]);
#endif

  if(index(emailaddr,'!')!=NULL||index(emailaddr,'@')!=NULL){
    for(i=0;i<2;i++)for(j=0;j<2;j++){
      sprintf(ex,"%s%s%s%s%s",start[i],user,"[@%]",host,end[j]);
      if(!casestep(ex,emailaddr)) {
        sprintf(ex,"%s%s!%s%s",start[i],host,user,end[j]);
        if(!casestep(ex,emailaddr)) {
          sprintf(ex,"%s%s.?*!%s%s",start[i],host,user,end[j]);
          if(!casestep(ex,emailaddr)) continue;
        };
      };
      return 1;
    };
  }else if(!strcmp(host,"?*")
          ||!strcasecmp(host,"localhost")){
    sprintf(ex,"%s%s%s",start[0],user,end[1]);
    if(casestep(ex,emailaddr)) return 1;
  };
  return 0;
}

