/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_GETOPT
#define IS_ERRNO
#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_TIME

#include "config.h"
#include "includes.h"
#include "readline.h"
#include "prototypes.h"

int outgoing(char *queue){
  FILE *fdin;
  int  i;
  int binary,compress;
  int lbinary,lcompress;
  char todays[LINESIZE],yesterdays[LINESIZE],s_time[7];
  char file[LINESIZE],replyto[LINESIZE],expression[LINESIZE],subject[LINESIZE];
  char lfile[LINESIZE],lreplyto[LINESIZE],lexpression[LINESIZE];
  static char *days_of_the_week[7]={"su","mo","tu","we","th","fr","sa"};
  struct BFILE today;
  struct BFILE yesterday;

  fdin=fdopen(0,"r");
  if(fdin==NULL){
    fprintf(fstdio[2],"%s\n","No fstdio[0]");
    exit(-1);
  };

/* I giveup on the ctime() stuff, this works, and is good enough for now
 * Sure it is in Zulu (Grenwish mean time), and in English, but you can't
 * have everything.
 */
  i=(time(0L)/60L);
  sprintf(s_time,"%d%c",(int) (i%60L+((i/60L)%24L)*100L+10000L),'z');
  i/= (60L*24L);
  sprintf(todays,"%s.%s",queue,days_of_the_week[(i+5)%7]);
  unlink(todays);
  sprintf(todays,"%s.%s",queue,days_of_the_week[(i+4)%7]);
  sprintf(yesterdays,"%s.%s",queue,days_of_the_week[(i+3)%7]);
  for(i=1;i<7;i++)s_time[i-1]=s_time[i];

/* Loop over the queue */

  fprintf(fstdio[1],"opening %s\n",todays);
  today.fd=fopen(todays,"a+");
  today.NR=0;
  rewind(today.fd);
  fprintf(fstdio[1],"opening %s\n",yesterdays);
  yesterday.fd=fopen(yesterdays,"r");
  yesterday.NR=0;
  while(fscanf(fdin," %d %d %[^>]> %s %s %[^\n]",&binary,&compress,replyto,file,
    expression,subject)==6){

    int i,pid,n,skip=0;
    char command[LINESIZE],dummy[6];
    char *s=command;

    strcat(replyto,">");
    if(yesterday.fd!=NULL){
      for(n=0;readline(&yesterday,n)>-1;n++){
        if(sscanf(yesterday.line," %s %[^>]> %s %d %d %s",dummy,lreplyto,lfile,&lbinary,
          &lcompress,lexpression)==6){
          strcat(lreplyto,">");
          if(!strcmp(lreplyto,replyto) 

             && !strcmp(lfile,file)
             && !strcmp(lexpression,expression)
             && lbinary == binary
             && lcompress == compress
          ){
            skip=1;
            break;
          };
        };
      };
    };
    if(skip) continue;
    if(today.fd!=NULL){
      for(n=0;readline(&today,n)>-1;n++){
        fprintf(fstdio[1],"%d %s\n",n,today.line); 
        if(sscanf(today.line," %s %[^>]> %s %d %d %s",dummy,lreplyto,lfile,&lbinary,
          &lcompress,lexpression)==6){
          strcat(lreplyto,">");
          if(!strcmp(lreplyto,replyto) 
             && !strcmp(lfile,file)
             && !strcmp(lexpression,expression)
             && lbinary == binary
             && lcompress == compress
          ){
            skip=1;
            break;
          }else{
            fprintf(fstdio[1]," %s %s %s %d %d %s\n",dummy,lreplyto,lfile,lbinary,
                                              lcompress,lexpression);
          };
        }else{
          fprintf(fstdio[1],"%d %s\n",n,today.line); 
        };
      };
    };
    if(skip) continue;

/* I hate using system(), but I see no other choise here... */

    s=command;
    sprintf(s,"(echo Subject: '%s';echo To: '%s';echo Precedence: %s;echo '';",
      subject,replyto,PRECEDENCE);
    if(!compress){
      sprintf(s+strlen(s),"sed 's/INSERT_STRING_HERE/%s/g'",expression);
      if(binary)
        sprintf(s+strlen(s),"|gzip -c|uuencode '%s'",file);
    }else if(!binary){
      strcat(s,"gzip -dc");
    }else{
      sprintf(s+strlen(s),"uuencode '%s",file);
      sprintf(rindex(s,'.'),"'");
    };
    strcat(s,")|" SENDMAIL " -i -t -bm");

    fprintf(fstdio[1],"Executing %s\n",command);
    if((pid=fork())==-1){
      fprintf(fstdio[2],"Fork failed\n");
      exit(-1);
    }else if(!pid){
      fprintf(fstdio[2],"%s\n",command);
      close(0);
      freopen(file,"r",fstdio[0]);
      if(fileno(fstdio[0])!=0)
        dup2(fileno(fstdio[0]),0);
      execl(SHELL,SHELL,"-c",command,(char *) 0);
      fprintf(fstdio[2],"Exec failed\n");
      exit(-1);
    };
    wait(&i);
    {
      long position;
      position=ftell(today.fd);
      fprintf(today.fd," %s %s %s %d %d %s \n",s_time,replyto,file,binary,
        compress,expression);
      fseek(today.fd,position,0);
    };
    fprintf(fstdio[2]," %s %s %s %d %d %s \n",s_time,replyto,file,binary,
      compress,expression);
    if(!i) fprintf(fstdio[2],"Exit %d\n",i);

/* Give the system time to process this requests... */

    sleep(15);
  };
  if(today.fd!=NULL)fclose(today.fd);
  if(yesterday.fd!=NULL)fclose(yesterday.fd);
  return 0;
};
    
