/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_STRING

#include "config.h"
#include "includes.h"
#include "readline.h"
#include "mailflags.h"
#include "prototypes.h"


 
/* This routine puts the mail in your mailbox and signals the daemons.
 *	MF_PRIVATE	==>  put in your mailbox
 *	MF_RECEIVE      ==>  signal receive daemon
 *      MF_OUTGOING	==>  signal outgoing daemon
 */

void mailme(struct BFILE *input, char *mailbox, char *home, long send){
  int i,n=0;
  FILE *fd;

#ifdef DEBUG
  fprintf(fstdio[1],"Entering mailme\n");
  fflush(fstdio[1]);
#endif

/* Place letter in your mailbox */

  if(mailbox!=NULL && (send & MF_PRIVATE) != 0){
    char savedline[LINESIZE+1];
    int body=0, tail=0;
#ifdef DEBUG
    fprintf(fstdio[1],"mailbox %s\n",mailbox);
#endif
    fd=fopen(mailbox,"a");
    if(fd==NULL){
      fprintf(fstdio[2],"Unable to deliver mail.\n");
      exit(1);
    };

    if((send&MF_FORWARD)!=0&&!(send&MF_COMMAND))
      for(i=1;!readline(input,i);i++)
        if(!strncmp(input->line,"From ",5)||!strncmp(input->line,">From ",6)){
          n=i;
          break;
        };

    *savedline='\0';
    for(i=0;readline(input,i)>=0;i++){
#ifdef DEBUG
      fprintf(fstdio[1],"mailme %d %s\n",strlen(input->line),input->line);
      fflush(fstdio[1]);
#endif
      if(*savedline!='\0'){
	fprintf(fd,"%s",savedline);
	*savedline='\0';
      };
      if(!strncmp(input->line,"From ",5)){
        if(i==n){
          fprintf(fd,"%s%s",input->line,RECEIVEDBY);
          if((send&MF_NOBASEDIR)!=0)
            fprintf(fd,"\t%s\n",
              "Private since no basedir was specified.");
          if((send&MF_NOTOACCESS)!=0)
            fprintf(fd,"\t%s\n",
              "Private since the letter wasn't addressed to you.");
          if((send&MF_NOFROMACCESS)!=0)
            fprintf(fd,"\t%s\n",
              "Private since queue access was denied to the sender.");
          if((send&MF_NOREPLYACCESS)!=0)
            fprintf(fd,"\t%s\n",
              "Private since queue access was denied to the receiver.");
          if((send&MF_SPECIAL)!=0)
            fprintf(fd,"\t%s\n",
              "Private since a special subject was used.");
          if((send&MF_SELF)!=0)
            fprintf(fd,"\t%s\n",
              "Private since getmail won't queue letters to itself.");
          if((send&MF_TRIED)!=0)
            fprintf(fd,"\t%s\n",
              "Private since a form letter was sent.");
          if((send&MF_UNKNOWN)!=0)
            fprintf(fd,"\t%s\n",
              "Private since the sender is unknown.");
          if((send&MF_FORWARD)!=0)
            fprintf(fd,"\t%s\n",
              "Private since this was forwarded by getmail.");
          if((send&MF_COMMAND)!=0)
            fprintf(fd,"\t%s\n",
              "Private since this contained " XCOMMAND ".");
          if((send&MF_HOPS)!=0)
            fprintf(fd,"\t%s\n",
              "Private since the hop count was exceeded.");
        }else if(!(send&MF_PROCESSED)){
          sprintf(savedline,">%s",input->line);
        }else
          sprintf(savedline,"%s",input->line);
      }else if(i==n && !strncmp(input->line,">From ",6)){
        sprintf(savedline,"%s",&input->line[1]);
      }else
        sprintf(savedline,"%s",input->line);

      if(strlen(input->line)<2){
        if(!strcmp(input->line,"\n")){
          tail=body;
          body=1;
        };
      }else tail=0;
    };
    if(index(savedline,'\n')!=NULL) fprintf(fd,"%s",savedline);

#ifdef DEBUG
    fprintf(fstdio[1],"Printing tail mailme\n");
    fflush(fstdio[1]);
#endif
    if(!(send&MF_PROCESSED)){
      if(!body)fprintf(fd,"\n");
      if(!tail)fprintf(fd,"\n");
    };
    fflush(fd);
  };

/* Signal recieve mail process */ 
 
  if((send & MF_RECEIVE) != 0) 
    signaldaemon(home,RECEIVE,send);

/* Signal outgoing mail process */

  send &= ~MF_FORTERM;
  if((send & MF_OUTGOING) != 0)
    signaldaemon(home,OUTGOING,send);

  exit(0);
}

