/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_ERRNO
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB
#define IS_SOCKET

#include "config.h"
#include "includes.h"
#include "readline.h"
#include "prototypes.h"


int inetconnect(char *port,char *hostname){
  char HostName[LINESIZE];
  struct hostent *hostaddress;
  struct sockaddr_in a;
  int s;

  if(rindex(port,':')!=NULL){
    strcpy(HostName,port);
    strcpy(rindex(HostName,':'),"");
    port=rindex(port,':')+1;
  }else{
    strcpy(HostName,hostname);
  };
  if(casestep("^[1-9][0-9]*.[0-9][0-9]*.[0-9][0-9]*.[0-9][0-9]*$",HostName)){
    a.sin_family = AF_INET;
    a.sin_addr.s_addr = inet_addr(HostName);
  }else{
    if(!(hostaddress=gethostbyname(HostName))){
      fprintf(fstdio[1],"gethostbyname failed\n");
      return -1;
    };
    a.sin_family=hostaddress->h_addrtype;
    a.sin_addr=*((struct in_addr *) hostaddress->h_addr);
  };
  a.sin_port = htons(atoi(port));
  if((s = socket(AF_INET, SOCK_STREAM, 0))<0) return -1;
  if(connect(s, (struct sockaddr *)&a,sizeof(struct sockaddr_in))<0){
    close(s);
    return -1;
  };
  return s;
}


