/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_STRING
#define IS_STAT

#include "config.h"
#include "includes.h"

/* Check the filetype.  0 == file, 1 == directory, -1 == does not exist */
/* Also check with extentions ".z" and ".gz". */

int getfiletype(char *file, char *path, char *base, int *size, int *compress){
  struct stat file_status;

  *size=0;
  sprintf(file,"%s/%s",path,base);
  *compress = 0;
  if(stat(file,&file_status)==-1){
    *compress=1;
    strcat(file,".gz");
    if(stat(file,&file_status)==-1){
      sprintf(file,"%s/%s.z",path,base);
      if(stat(file,&file_status)==-1) return -1;
    };
  }else if((file_status.st_mode&S_IFDIR)!=0){ /* Is it a directory? */
    strcpy(path,file);
    return 1;
  };
  if((file_status.st_mode&S_IFREG)!=0){
    *size=(int) ((!*compress ? 1.0 : COMPRESSION_FACTOR) * (float) file_status.st_size);
    return 0;
  };
}

