/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_FCNTL
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB
#define IS_STDIO
#define IS_REGEX

#include "config.h"
#include "includes.h"
#include "prototypes.h"

/* This routine checks for an expression "ex" in String.  Standard regular
 * expressions are used, with the exception that ANYCHAR means any character
 * instead of '.'.  (This is so specifying user names is easier...)
 */

int casestep(char *ex, char *String){
  char e[LINESIZE],s[LINESIZE],expbuf[BUFFERSIZE];
  char *t=e,*u=s,*v;
  
  for(v=String;*v!='\0';v++) *(u++)=tolower(*v);
  *u='\0';

  for(v=ex;*v!='\0';v++){
    switch (*v){
    case ANYCHAR:
      *(t++)='.';
      break;
    case '\\':
      v++;	/* Allow this to fall through */
    case '.':
      *(t++)='\\';
    default:
      *(t++)=tolower(*v);
      break;
    };
  };
  *t='\0'; 

#ifdef DEBUG
  fprintf(fstdio[1],"? %s =~ %s\n",e,s);
  fflush(fstdio[1]);
#endif
  {
#ifdef USE_STEP
    char expbuf[BUFFERSIZE];
    compile(e,expbuf,&expbuf[BUFFERSIZE],'\0');
    return step(s,expbuf);
#else
    regex_t preg;
    static regmatch_t pmatch[1];
    int j;

    regcomp(&preg,e,0);
    j=!regexec(&preg,s,0,pmatch,REG_NOSUB);
    regfree(&preg);
    return j;
#endif
  };
}

