/* $Id: conf.h,v 1.1 94/07/11 18:34:42 listserv Exp Locker: listserv $
 *
 *  Copyright (C) 1991,1992  Kimmo Suominen, Christophe Wolfhugel
 *
 * Please read the files COPYRIGHT and AUTHORS for the extended
 * copyrights refering to this file.
 * Configuration information for use by LISTSERV.
 * Change these as appropriate for your system.
 *
 */

/*
 * TULPDIR defines the directory where all service files are accessible,
 * such as list of lists, etc... TULP chdir()'s to that at startup.
 */

#define TULPDIR		"/usr/users/listserv/expl"

/*
 * QUEUEDIR is relative to TULPDIR and defines the place where the
 * messages are queued for future processing.
 */

#define QUEUE_DIR	"queue"

/*
 * UMASK to apply to files.
 */

#define UMASK	077

/*
 * Place where programs sendmail and mailx lie on your system.
 *
 * To run sendmail in background use "-odb" instead of "-odi".
 * This will result in faster LISTSERV replies, but increases
 * load on your system because of the many sendmail processes.
 *
 * Note: with the new "windowed" popen, it is preferable to use 
 * the interactive delivery mode.
 */

#define SENDMAIL  "/usr/sbin/sendmail -oi -odi -oem -oMrTULP"
#define SMTPMAIL  "/usr/sbin/sendmail -bs"	/* Experimental: not used yet */

/*
 * Following string is the shutdown command, when sent to the listserv
 * makes a clean and safe shutdown. Useful if there are several admins
 * some may not have access to the system running it.
 *
 * Change this from the default! Multi words is OK.
 *
 * If undefined, the option is not hardcoded. Don't forget the 
 * newline in the string.
 */

#define SHUTDOWN	"shitdown\n"

/*
 * If you don't have support for syslog, but want a facsimile,
 * define FAKESYSLOG to be the name of a file to which to log stuff,
 * otherwise the standard syslog will be used.
 *
 *      #define FAKESYSLOG      "/usr/adm/listlog"
 *
 */

#undef	FAKESYSLOG "syslog"

/*
 * This is frequently used text, rename to fit your needs
 */

#define VERSION	"4.1.0"		/* No longer than this! */

/*
 * If undefined then the statistics junk at the end of a command message
 * about CPU usage and other stuff will not be sent to the user.
 * Some dislike to get those lines.
 */

#define CPUTYPE "i486 Linux" /* Put your CPU type here */

/*
 * NICENESS is the process priority decrement to be used.
 *
 * Usually message forwarding is not considered critical and thus
 * you should choose a value over 0.  If the normal priority on
 * your system is 20, then 19 is the maximum niceness you should
 * use, because the lowest priority is usually 39.  Using values
 * above that (more decrement) may cause unpredictable results.
 * Under HP-UX your process might get stuck sometimes when using
 * an invalid value.
 */

#define NICENESS 18

/*
 * BATCHSIZE is the maximum number of recipients in each batch sent.
 * Does not limit the number of people on any single list.
 * Use a value between 20 to 40, do NOT exceed 40.
 * The smaller the value, the more often sendmail will be called.
 * If you run sendmail in background, a small value results in many
 * sendmail processes running for a large list!
 */

#define BATCHSIZE 30

/*
 * Define ADD_SENDER, if you want a "Sender: list-errors" header.
 * This implies the need of the list-errors alias to someone (not listserv).
 * If your mail agent handles correctly envelopes and if you did trust listserv
 * and if you use ADD_REQUEST it might be possible to keep this undefined.
 */

#undef	ADD_SENDER		/* Sender */

/*
 * Define ADD_REQUEST, if you prefer envelope sender of listname-request.
 * Also, listserv job requests will be from listserv-request, so you will
 * need that defined as an alias to someone (not listserv itself).
 * This needs listserv as a trusted user in your sendmail configuration.
 * Add a line like "Tlistserv" after the other T-lines in "sendmail.cf".
 *
 * It is strongly recommended to keep this line defined (and create
 * the appropriate aliases, listserv-request and xxx-request for
 * each list). By undefining this option you may reate loops
 * in case of error messages being bounced.  Take care...
 */

#define ADD_REQUEST		/* -fxxx-request to sendmail */

/*
 * If you want the Received: headers to be stripped from incoming
 * messages (to be redistributed) define this option.
 * Default is undefined and it is extremely dangerous to strip those
 * vital lines. You may generate deadly loops, for you and for the
 * network if you define this.
 */

#undef STRIP_RECEIVED		/* Keep undefined please */

/*
 * Choose one of the three ways to get your hostname
 * 1) USE_GETHOSTNAME   use gethostname followed by gethostbyname
 * 2) USE_UNAME         use uname followed by gethostbyname
 * 3) HOST              use the static string - cannot share the executable
 *
 * Using gethostbyname in 2) and 3) will result in your fully qualified
 * domain name (FQDN), if your system is properly configured.  That is,
 * if you don't use Domain Name Service, the FQDN must be the first name
 * for your address in /etc/hosts or NIS-map hosts.byname.  This is the
 * standard way, so there should be no trouble.
 */

#define USE_GETHOSTNAME          /* Use gethostname and gethostbyname */
#undef USE_UNAME		 /* Use uname and gethostbyname */
/* #define HOST "host.foo.bar"*/ /* Max 50 characters */


/*
 * If your system does not have the strcase functions, define
 * following option.
 */

#undef	NEED_STRCASE		/* Need strcasecmp and strncasecmp */


/*
 * You should probably better not change following defines, but in case
 * the defaults do not fit your needs. Be sure of what you do.
 * Those values have been fetched from Sendmail-IDA (conf.h) and are
 * unchanged for TULP.
 */

#define	MAXLINE		1024		/* max line length */
#define MAXFIELD	4096		/* max total length of a hdr field */

/*----- STOP ---- no more modifications below ----- STOP ----------*/

#include "internal.h"
