/*-------------------------------------------------------------------------
 *  TULP - Unix Mailing List manager (sub-set of FRECP's
 *         Bitnet Listserv tool.
 *
 *  Copyright (C) 1991,1992  Kimmo Suominen, Christophe Wolfhugel
 *
 *  Please read the files COPYRIGHT and AUTHORS for the extended
 *  copyrights refering to this file.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *----------------------------------------------------------------------*/

static char rcsid[] = "@(#)$Id: ad.c,v 1.1 94/07/11 18:34:42 listserv Exp $";

#include <stdio.h>
#include <string.h>
#include "conf.h"
#include "ext.h"

static char *adrs,*name;
static char line[3][MAXLINE];

void adChange(s)
char *s;
{
   int state,i,j,quote=0,parlvl=0;
   char *lns[3],*save=s;

   state=0; memset(line[0],0,sizeof(line));
   lns[0]=line[0]; lns[1]=line[1]; lns[2]=line[2];
   while (*s!=0) {
      if (*s=='"') quote=1-quote;
      if (quote==1) { *lns[state]++= *s; s++; continue; }
      switch (*s) {
      case '<':
         state=1;
         break;
      case '(':
         parlvl++;
         state=2;
	 if (parlvl > 1) *lns[state]++ = '(';
         break;
      case '>':
         state=0;
         break;
      case ')':
         if (--parlvl) { *lns[state]++ = ')'; break; }
         state=0;
         break;
      default:
         *lns[state]++= *s;
      } /* endswitch */
      s++;
   } /* endwhile */
   lns[0]=line[0]; lns[1]=line[1]; lns[2]=line[2];
   for (i=0; i<2; i++) {
      while (*lns[i]==' ') lns[i]++;
      j=strlen(lns[i]);
      while (j>0 && lns[i][j-1]==' ') lns[i][--j]=0;
   } /* endfor */
   if (lns[1][0]!=0) {    /* Adress between <> */
      adrs=lns[1];
      name=lns[0];
   } else {
      adrs=lns[0];
      name=lns[2];
   } /* endif */
   if (strchr(adrs,'@')==NULL && strchr(adrs,'!')==NULL) {
      strcat(adrs,"@");
      strcat(adrs,HOST);
   } /* endif */
   if (*name!=0) sprintf(save,"%s (%s)",adrs,name); else strcpy(save,adrs);
}
