/*
 *   Copyright (c) 2000 Embryo Software (Juan F. Codagnone)
 *	         Todos los derechos reservados
 *
 *   Nombre:        MAIN.C
 *   Autor:         Juan F.Codagnone <fliacoda@internet.siscotel.com>
 *   Fecha:         07/01/2000						
 *   Descripcin:   Programa para encriptar/desencriptar BASE64.
 *   Plataformas:   Escrito en ANSI C. (deberia andar en todas las
 *                  platformas que soportan C no?)
 *
 *   Sugerencias?... Mail me.
 *
 *   Hecho en Argentina.
 *
 *   Licencia:
 *	
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include "implementacion.h"
#include "getopt.h"

#define MAYOR_VERSION 1
#define MINOR_VERSION 1

/* Ups una variable global no!!! */
char* progname=0;

static void usage(char *progname)
{	printf(	"BASE64 %d.%d (c) Copyright 2000 Embryo Software.\n"
		"Usage: %s [OPTIONS] [FILE]\n"
		"Encodes FILE, or standard input, to standard output .\n"
		"\n"
		"  -d\t\tdecodes FILE (or stdin)\n"
		"  -h\t\tdisplay this help and exit\n"
		"  -n num\tlets you choose the numbers of characters per line\n"
		"\t\t(RFC 1341 lets at most 76)\n"
		"  -o filename\tsend output to filename, not to stdout\n"
		"  -v\t\tprint version information and exit\n"
		"\n"
		"With no FILE, or when FILE is -, read standard input.\n"
		"Please report bugs and suggestions to fliacoda@internet.siscotel.com\n"
		,MAYOR_VERSION,MINOR_VERSION,progname);	
}

static void version(char *progname)
{	printf("%s %d.%.2d (c) Copyright 2000 Embryo Software. All rights reserved.\n",progname,MAYOR_VERSION,MINOR_VERSION);
}

int main(int argc,char *argv[])
{	FILE *in,*out;
	int i;
	struct 
	{	short decode;
		short len;
		char *archivo;
	}opciones={0,60,0};

	progname=argv[0];	
	
	while ((i = getopt(argc, argv, "vhdo:n:")) != -1)
		switch(i)
		{	case 'v':
				version(argv[0]);
				exit(0);
				break;
			case 'h':
				usage(argv[0]);
				exit(0);
				break;
			case 'd':
				opciones.decode=1;
				break;
			case 'o':
				opciones.archivo=optarg;
				break;
			case 'n':
				opciones.len=atoi(optarg);
				if(opciones.len>76||opciones.len<4)
				{	fprintf(stderr,"%s: each output line must be 3 < lenth < 76 characters\n",argv[0]);
					exit(-1);
				}
				break;
			default:
				fprintf(stderr,"%s: try '%s -h'\n",argv[0],argv[0]);
				exit(-1);
				break;
		}

	i=optind;

	/* si no se espesifico archivos o archivo = "-" leemos del stdin */
	if(optind==argc||((argv[i][0]=='-')&&(!argv[i][1])))
		in = stdin;
	else if((in=fopen(argv[i],"rb"))== NULL)
	{	fprintf(stderr,"%s: couldn't create %s\n",argv[0],argv[i]);
		return -2;
	}

	/* si se espesifico salida guardamos ahi */
	if(!opciones.archivo)
		out=stdout;
	else if((out=fopen(opciones.archivo,"wb"))== NULL)
	{	fprintf(stderr,"%s: couldn't create %s\n",argv[0],opciones.archivo);
	 	return -3;
	}

	if(opciones.decode)
		base64Decode(in,out);
	else
		if(base64Encode(in,out,opciones.len)<0)
				/* Esto no deberia aparecer nunca debido a que se hacen todos los chekeos
				   cuando se pasan los parametros */
				fprintf(stderr,"%s: error encoding to base64.\n",argv[0]);

	/* si abrimos algun archivo es hora de cerrarlo */
	if(optind!=argc)
		fclose(in);
	if(opciones.archivo)
		fclose(out);

	return 0;
}