/*
 *   Copyright (c) 2000 Embryo Software (Juan F. Codagnone)
 *	         Todos los derechos reservados
 *
 *   Nombre:        BASE64.C
 *   Autor:         Juan F.Codagnone <fliacoda@internet.siscotel.com>	
 *   Fecha:         28/06/2000						
 *   Descripcin:   Implementacion de encoder/decoder BASE64 en ANSI C
 *                  segun el RFC 1341.
 *   Plataformas:   Escrito en ANSI C. (deberia andar en todas las
 *                  platformas que soportan C no?)
 *
 *   Sugerencias?... Mail me.
 *
 *   Hecho en Argentina.
 *
 *   Licencia:
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <stdio.h>
#include "base64.h"

/* Global Data :^( */
/* Contintiene el nombre del programa para las llamadas de error */
extern char *progname;

/*  base64Encode()
 *  Descripcion.
 *    Encodea in a out
 *  Params.
 *    in : stream a encodear
 *    out: stream a donde va lo encodeado
 *	  len: longitud de linea (maximo 75 segun el rfc)
 *  Return
	  0 todo ok
	  <0 error -> -1 = Mala longitud
 */
int base64Encode(FILE *in,FILE *out,unsigned short len)
{	unsigned int cuenta=0;

	if(len>76||len<=0)
	  return -1;

	while(1)
	{	int b[3];
		char c[3];
		char retornar=FALSE;
		unsigned char i;
		
		for(i=0;i<3;i++)
		{	b[i]=getc(in);
			if(b[i]==EOF)
				break;
		}

		if(i==0)
			break;
		
		encbase64(b,i,c);

		if(cuenta>=len)
		{	putc('\n',out);
			cuenta=0;
		}
		cuenta+=4;
		fwrite(c,sizeof(*c),4,out);

		if(retornar == TRUE)
			break;
	}
	putc('\n',out);

	return 0;
}

/*  base64Decode()
 *  Descripcion.
 *    Desencodea in a out
 *   Params.
 *    in : stream a encodear
 *    out: stream a donde va lo encodeado
 */
void base64Decode(FILE *in,FILE *out)
{	unsigned int cuenta=0;

	for(;;)
	{	char c[3],b[4];
		unsigned char i;
		/*	"... 
			The output stream (encoded bytes) must be
			represented in lines of no more than 76
			characters each. All line breaks or other
			characters not found in Table 1 must be 
			ignored by decoding software. In base64 data,
			characters other than those in Table 1, line
			breaks, and other white space probably indicate
			a transmission error, about which a warning message
			or even a message rejection might be appropriate
			under some circumstances. ..." -- RFC 1341
		*/
		
		/* Necesitamos los 4 grupos de 6bit */
		for(i=0;i<4;i++)
		{	c[i]=getc(in);
		
			if(c[i]==EOF)
				break;
		
			/* si no es base64 la ignoramos y buscamos otra */
			while(!isbase64(c[i]))
			{	if(c[i]=='=')
					break;
				else if(c[i]==EOF) 
					break;		/* no tiene sentido seguir buscando.. */
				else if(c[i]!='\r'&& c[i]!='\n' && c[i]!=' ')
					fprintf(stderr,"%s: warning. character (%#x) unknow (ignored)\n",progname,c[i]);
				/* buscamos */
				c[i]=getc(in);
			}
			
			/* transformamos el caracter en un numero */
			if(c[i]!=EOF)
				c[i]=numbase64(c[i]);
				
			if(c[i]==EOF)
				break;
		}
		
		if(i==0)
			break;

		if(i!=4)
			fprintf(stderr,"%s: file incomplete (24 bits group is incomplete)\n",progname);
		
		i=decbase64(c,b);
		fwrite(b,sizeof(*b),i,out);
	}
}