/*
 *   Copyright (c) 2000 Embryo Software (Juan F. Codagnone)
 *	         Todos los derechos reservados
 *
 *   Nombre:        BASE64.C
 *   Autor:         Juan F.Codagnone <fliacoda@internet.siscotel.com>	
 *   Fecha:         21/02/2000						
 *   Descripcin:   Grupo de funciones para poder aplicar BASE64
 *                  segun el RFC 1341.
 *   Plataformas:   Escrito en ANSI C. (deberia andar en todas las
 *                  platformas que soportan C no?)
 *
 *   Sugerencias?... Mail me.
 *
 *   Hecho en Argentina.
 *
 *   Licencia:
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "base64.h"

const char alfabetoBase64[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/*  encbase64()
 *  Descripcion.
 *    Toma 3 bytes y los convierte en 4, es decir, aplica  base64.
 *  Params.
 *    b : los 3 bytes entrantes
 *    n : la cantidad de bytes entrantes (3,2 o 1)
 *    c : los 4 bytes salientes 
 *
 */
char *encbase64(int *b,int n,char *c)
{	
	/* "
	Special processing is performed if fewer than  24  bits  are
    available  at  the  end  of  the data being encoded.  A full
    encoding quantum is always completed at the end of  a  body.
    When  fewer  than  24  input  bits are available in an input
    group, zero bits  are  added  (on  the  right)  to  form  an
    integral number of 6-bit groups..."
		 -- RFC 1341 
	*/
	if(n==2)
		b[2]=0;
	if(n==1)
		b[1]=0;


	/*"...
	The encoding process represents 24-bit groups of input  bits
	as  output  strings of 4 encoded characters. Proceeding from
	left  to  right,  a  24-bit  input  group   is   formed   by
	concatenating  3  8-bit input groups. These 24 bits are then
	treated as 4 concatenated 6-bit groups,  each  of  which  is
	translated  into a single digit in the base64 alphabet..."
			-- RFC 1341
	*/

	c[0]=alfabetoBase64[b[0]>>2];
	c[1]=alfabetoBase64[((b[0] & 0x03) << 4) | ((b[1] & 0xf0) >> 4)];
	c[2]=alfabetoBase64[((b[1] & 0x0f) << 2) | ((b[2] & 0xc0) >> 6)];
	c[3]=alfabetoBase64[b[2] & 0x3f];

	/*"...
	Output character positions which are not required to
	represent actual input data are set to the character
	"=". ..."  -- RFC 1341 
	*/
	if(n<=2)
		c[3]='=';
	if(n<=1)
		c[2]='=';

	return c;
}

/*  decbase64()
 *  Descripcion.
 *    Toma 4 bytes y los convierte en 3, es decir, desencodea
 *    base64.
 *  Params.
 *    c : los 4 bytes entrantes 
 *    b : los 3 bytes entrantes
 *  Retorna
 *    La cantidad de bytes que quedaron de la salida
 *    (por si en c habia algun '=')
 *  Notas.
 *    '=' debe ingresar como 65.
 */
int decbase64(char *c,char *b)
{	short n;

	if(c[2] == 65)
	{	n = 1;
		c[2] = c[3] = 0;
	}
	else if(c[3] == 65)
	{	   n = 2;
		c[3] = 0;
	}
	else
		n = 3;

	b[0] = (c[0] << 2) | (c[1] >> 4);
	b[1] = ((c[1] & 0x0f) << 4) | (c[2] >> 2);
	b[2] = ((c[2] & 0x3) << 6) | c[3];

	return n;
}

/*  isbase64()
 *  Descripcion.
 *    Si c pertenece al alfabeto base64 devuelve TRUE.
 *  Params.
 *    c : caracter a chequear.
 *  Retorna
 *    TRUE pertenece al alfabeto.
 *    FALSE no pertenece al alfabeto.
 *  Notas.
 *    '=' no pertenece al alfabeto
 */
short isbase64(char c)
{	/* Optimizado: no necesito recorrer los 65 caracteres del alfabeto de BASE64
	 * para saber si es... Con 5 comparaciones me alcanza y sobra.
	 */

	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||(c>='0'&&c<='9')||c=='+'||c=='/')
		return TRUE;

	return FALSE;
}

/*   numbase64()
 *   Descripcion.
 *    Retorna la posicion de la letra en el abcedario.
 *   Params.
 *    c : caracter a chequear.
 *  Retorna
 *    La posicion en abcdario.
 *    Si c es '=' returna 65.
 *    Si c no pertenece al abcdario retorna -1
 *  Notas.
 *    '=' no pertenece al alfabeto
 */
byte numbase64(char c)
{	/* Optimizado. antes como maximo hacia 65 comparaciones, ahora 8) */
	if(c>='A'&&c<='Z')
		return c-'A';
	else if(c>='a'&&c<='z')
		return c-'a'+26;
	else if(c>='0'&&c<='9')
		return c-'0'+52;
	else if(c=='+')
		return 62;
	else if(c=='/')
		return 63;
	else if(c=='=')
		return 65;
	else
		return -1;
}
