#ifndef HWCLOCK_UTIL
#define HWCLOCK_UTIL

#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/time.h>

#ifndef TRUE
typedef int bool;
#define TRUE 1
#define FALSE 0
#endif

#define FLOOR(arg) ((arg >= 0 ? (int) arg : ((int) arg) - 1))
#define ABS_VALUE(arg) ((arg) > 0 ? (arg) : -(arg))

extern bool
is_in_cpuinfo(const char * const fmt, const char * const str);

extern char *
ctime2(const time_t time);

extern struct timeval
t2tv(time_t argument);

extern struct timeval
t2tv(time_t argument);

extern float 
time_diff(struct timeval subtrahend, struct timeval subtractor);

extern struct timeval
time_inc(struct timeval addend, float increment);

int
local_time_offset(time_t const time);

/* We'd like to inline this, but the compiler says it can't inline a varargs
   function.
*/
static void __attribute__ ((__format__ (__printf__, 2, 3)))
casprintf(const char ** const retvalP, const char * const fmt, ...) {

    char *retval;

    va_list varargs;  /* mysterious structure used by variable arg facility */

    va_start(varargs, fmt); /* start up the mysterious variable arg facility */

    vasprintf(&retval, fmt, varargs);
    *retvalP = retval;
}

/* The following exists only to prevent a compiler warning about casprintf()
   being declared not used.  Because this function is in a common header
   file, it's perfectly OK for a file that includes this header file to 
   declare casprintf() but not use it.
*/
inline static void dummyCasprintfRef(void) {
    const char ** string;
    casprintf(string, "dummy");
}

inline static void
freeString(const char * const arg) {
    free((void *) arg);
}
#endif
