#ifndef HWCLOCK_H
#define HWCLOCK_H
#include <time.h>
#include <unistd.h>

#include "util.h"

#define MYNAME "hwclock"
#define VERSION "2.24"


enum hwclock_operation {OP_SHOW, OP_SET, OP_SYSTOHC, OP_HCTOSYS, OP_ADJUST,
                        OP_GETEPOCH, OP_SETEPOCH, OP_VERSION};


/* hwclock.c */
extern int debug;
extern const bool alpha_machine;
extern const bool isa_machine;

/* rtc.c */
void
synchronize_to_clock_tick_RTC(int * const retcode_p,
                              char rtc_filespec[]);

void
read_hardware_clock_rtc_ioctl(const char rtc_filespec[],
                              struct tm * const tm_p);

void
set_hardware_clock_rtc_ioctl(const struct tm new_broken_time, 
                             const char rtc_filespec[],
                             const bool testing);
void
see_if_rtc_works(const char specified_filespec[], 
                 char ** const error_p);

void
find_default_rtc(char ** const filespec_p,
                 char ** const error_p);

void
get_epoch(const char rtc_filespec[], unsigned long *epoch_p, char **reason_p);

void
set_epoch(const char rtc_filespec[], 
          unsigned long epoch, const bool testing, int *retcode_p);


/* kd.c */

extern void
synchronize_to_clock_tick_KD(int *retcode_p);

extern void
read_hardware_clock_kd(struct tm *tm);

extern void
set_hardware_clock_kd(const struct tm new_broken_time, 
                      const bool testing);

extern void
see_if_kdghwclk_works(bool * const kdghwclk_works_p);

/* utmp.c */
void 
update_utmp(const struct timeval oldtime,
            const struct timeval newtime);


#endif
