#ifndef ADJTIME_H
#define ADJTIME_H
enum a_local_utc {LOCAL, UTC};

struct adjtime {
    /* This is information we keep in the adjtime file that tells us how
       to do drift corrections, among other things.  Elements are all
       straight from the adjtime file, so see documentation of that file
       for details.  Exception is <dirty>, which is an indication that
       what's in this structure is not what's in the disk file (because
       it has been updated since read from the disk file).  
    */

    bool dirty;        
    float drift_factor;    
    time_t last_adj_time;
    float not_adjusted;
    time_t last_calib_time;
        /* The most recent time that we set the clock from an external 
           authority (as opposed to just doing a drift adjustment)
        */
    enum a_local_utc local_utc;
        /* To which time zone, local or UTC, we most recently set the
           hardware clock.
        */
    int tzOffset;
        /* Number of seconds west of the prime meridian the local time in
           the hardware clock is.  Zero if the hardware clock is in UTC.
        */
    int epoch;
        /* The Gregorian year number of the year to which a value of zero
           in the hardware clock's year register refers.  -1 for unknown.
        */
    float last_adj_frac;
};


#define ADJTIME_PATH "/etc/adjtime"

void
read_adjtime(struct adjtime * const adjtime_p, 
             const char **    const errorP,
             bool             const debug);

void
save_adjtime(struct adjtime const adjtime, 
             bool           const testing,
             bool           const debug);

#endif
