#!/bin/bash

# This is a data collection script to aid in testing/debugging the hwcfg
# utility

DATAPATH=/tmp/hwcfg
mkdir $DATAPATH
mkdir $DATAPATH/proc
mkdir $DATAPATH/proc/net
mkdir $DATAPATH/proc/scsi

cd $DATAPATH

# Gather info from various commands
uname -m > uname
free > free
dmesg > dmesg
ifconfig -a > ifconfig
setserial -g /dev/cua0 > setserial
setserial -g /dev/cua1 >> setserial

# Gather proc files (to get contens had to cat files into others)
for FILELIST in /proc/ioports /proc/cpuinfo /proc/interrupts /proc/dma /proc/pci /proc/net/dev /proc/scsi/scsi
do
  cat $FILELIST > ${DATAPATH}$FILELIST
done

# Replicate directoris in /proc/scsi
for FILELIST in `find /proc/scsi/* -type d -print`
do
  mkdir ${DATAPATH}$FILELIST
done

# Last, cpio all gathered info for transmission
find . -print | cpio -o --format=newc -O/tmp/proc.cpio

# rm -r $DATAPATH
