


DRAM(8)              Linux Programmers Manual             DRAM(8)


NNAAMMEE
       dram - set the system DRAM refresh timer period

SSYYNNOOPPSSIISS
       ddrraamm refresh_period


WWAARRNNIINNGG::
       You  are  changing low level hardware parameters with this
       program, and can easily crash your system by giving  it  a
       refresh  period  that  is too long. (You will be warned by
       the  program too.)  You REALLY should go single  user  and
       re-mount  all  filesystems as read-only before experiment-
       ing.


DDEESSCCRRIIPPTTIIOONN
       ddrraamm is a program to set the refresh period  of  the  DRAM
       refresh   timer   on  PC  architecture  to  _r_e_f_r_e_s_h___p_e_r_i_o_d
       microseconds.

       In the beginning there was the XT. And it had crummy  mem-
       ory.  The little storage cells of the memory would quickly
       forget what they were trying to remember. Your memory for-
       gets  what  it  is  remembering  unless  you give it a jab
       (refresh) every so often. Because of the  poor  memory  in
       those  days,  the  engineers chose a conservative value of
       one refresh every 15us (microseconds) by default.

       Now each megabyte of memory has almost  9.5  *million*  of
       these  cells.  You can imagine that it will eat up some of
       the computer's power to  read  and  re-write  *all*  these
       cells  every  0.000015 seconds.  (A refresh cycle involves
       reading a value from memory, and then writing it  back  to
       the memory cell again.)

       Well,  the  basic design is the same in todays modern SIMM
       (Single Inline Memory Module) but they can do much  better
       than  being  able to remember for a mere 15us. Todays DRAM
       (Dynamic Random Access Memory) chips on  the  common  SIMM
       you  have  are capable of having a refresh only once every
       500 --> 1000 us or more.

       Some motherboards have a BIOS option "Slow Refresh", which
       changes  the refresh from 15us to a more reasonable value,
       like 120us.  This is *still* conservative, but better. And
       good  motherboards will have a "Hidden Refresh" option (or
       will silently implement one) so that it  hardly  holds  up
       the computer at all when it is doing a refresh.

       Even  if  your  BIOS  does *not* have this option, you can
       change the time period of the refresh timer with this sim-
       ple Linux program.




Dram 1.00                   26 Aug 94                           1





DRAM(8)              Linux Programmers Manual             DRAM(8)


       You  should  know  when  you  have  exceeded  a reasonable
       refresh time for your memory, as you will get  NMI's  (Non
       Maskable  Interrupts)  which  will  report "parity errors"
       meaning that your memory  is  starting  to  forget  stuff.
       Linux  will report a message like "NMI received: dazed and
       confused but trying to continue". Parity is a 9th bit that
       is  always  set  so that the sum of the 8 bits of the data
       byte plus the ninth parity bit will _a_l_w_a_y_s be an even num-
       ber.  If the computer sees some memory in which the sum is
       not an even number, then it knows the memory  has  changed
       by  itself,  and  reports a parity error. I would say that
       any time used that is less  than  1000us  is  "reasonably"
       safe.

       Note  that  some  el-cheapo  systems use 8-bit DRAM, which
       means that there is no parity bit. In this case, there  is
       no safety-check against memory corruption, and the operat-
       ing  system  will  proceed  until  the  memory  corruption
       crashes  the  system. Some system BIOS setup programs will
       allow you to either watch or ignore the parity bit -- this
       is to allow these systems to use the (broken) 8-bit memory
       described above.  Make sure that the parity bit is enabled
       if you have ok DRAM/SIMM.

       Note  that  there  is no point in pushing the timer to the
       brink of the parity error limit, because most of the  gain
       is  achieved long before that. Consider the following data
       I took on an old 12MHz AT (286) computer  (using  the  DOS
       version of the program).

       DRAM refresh (us)     Landmark v2.00 rating     % increase
              15                  15.48                    0
              120                 16.14                    4.26
              250                 16.19                    4.59
              500                 16.21                    4.72
              1000                16.22                    4.78
              2000                16.22                    4.78
              5000                16.23                    4.84
              10000               16.23                    4.84
              20000               16.23                    4.84

       (Note that at 10000 and 20000, the machine  would  eventu-
       ally  have  a  parity error as described above.) As can be
       seen from the above data, we get about a  5%  increase  in
       speed  with  the  *longest*  refresh  period,  and  we had
       already obtained over 97% of the maximum possible increase
       with a nice "safe" value of 500us.



BBUUGGSS
       If  your motherboard is already (silently?) doing a 120us,
       or hidden refresh, you may  not  even  see  a  difference.
       Given  the  above  data,  the  difference  between a 120us



Dram 1.00                   26 Aug 94                           2





DRAM(8)              Linux Programmers Manual             DRAM(8)


       refresh, and the longest refresh tested was  only  a  mere
       0.5%

       Since  you are doing all sorts of low level I/O when using
       this program, you must be root to read or write any of the
       configuration  parameters.  If  you do not have root priv.
       you will be told so, and the program will exit.

       Also,  selecting  too  long  a  wait  between  consecutive
       refresh  cycles  will  cause  parity errors and eventually
       crash the machine.


AAUUTTHHOORR
       The program was adapted from the DOS version of  the  same
       program.    Program   and   man  page  by  Paul  Gortmaker
       (Paul.Gortmaker@anu.edu.au)








































Dram 1.00                   26 Aug 94                           3


