/* rm.c
 * by: Todd Burgess 
 * tburgess@netcom.ca
 * Contains the routines to destroy the file
*/

#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>

#include "rm.h"

long get_fsize (char *filename)
/* returns the file size of the file specified by filename 
 * on success returns the filesize, on error returns -1
*/

{
	struct stat buf;
	
	if (stat(filename,&buf) == 0)
		return buf.st_size;
	else
		return -1;
}

void remove_file (char *filename) 
/* this will remove the file specified by filename
 * first we destroy the contents of filename and then we unlink it
*/

{
	long size;

	size = get_fsize (filename);

	if (size == -1)
		return;

	insecure_overwrite (filename,size);
	unlink (filename); 

}

void insecure_overwrite (char *filename,long size)
/* this will overwrite the contents of filename with 0's only 
 * once. it is not the best way of destroying data but hopefully
 * given time I will develop more "secure" methods
*/

{
	int fd;
	int x;

	fd = open (filename,O_WRONLY);

	if (fd == -1) 
		return;

	for (x=0;x<size;x++) {
		write (fd,"0",1);
	}

}
	
	
