/*
 *  ntfstools.c
 *  Helper functions for the tools
 *  Copyright (C) 1995 Martin von Lwis
 */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include "config.h"
#include "ntfs.h"
/* glibc string.h does not define a memcpy prototype */
void* memcpy(void*,const void*,size_t);

ntfs_volume *the_vol;
ntfs_volume myvol;

/* pmemcpy is ignored here */
int ntfs_get_clusters(void *pvol,int cluster,size_t offs,
	size_t count,void *buf,copyfunction pmemcpy)
{
	ntfs_volume *vol=pvol;
	if(lseek(vol->ntfs_fd,cluster*NTFS_CLUSTERSIZE+offs,SEEK_SET)==-1)
		return 0;
	if(read(vol->ntfs_fd,buf,count)==-1)
		return 0;
	return 1;
}

void ntfs_release_cluster(void *data)
{
	free(data);
}

int open_volume(char *name)
{
	int fd=open(name,O_RDONLY);
	if(fd==-1)perror("open");
	return fd;
}

void ntfs_error(char*s,int a1,int a2,int a3,int a4,int a5)
{
	fprintf(stderr,s,a1,a2,a3,a4,a5);
	fputs("",stderr);
}

void *ntfs_allocate(int size)
{
	return malloc(size);
}

void ntfs_free(void *block)
{
	free(block);
}

int ntfs_open_volume(char *file,int silent)
{
	int fd;
	char cluster0[NTFS_CLUSTERSIZE];
	the_vol=&myvol;
	the_vol->ntfs_fd=fd=open_volume(file=file?file:NTFS_VOLUME);
	if(fd<0)
	{	
		return 0;
	}
	/* read the boot sector */
	ntfs_get_clusters(the_vol,0,0,NTFS_CLUSTERSIZE,cluster0,memcpy);
	if(!IS_NTFS_VOLUME(cluster0)){
		fprintf(stderr,"Not a NTFS volume:%s",file);
		return 0;
	}
	/* read the first mft record */
	the_vol->mft_block=*(int*)(cluster0+0x30);
	the_vol->mft=malloc(NTFS_MFT_RECORDSIZE);
	ntfs_get_clusters(the_vol,the_vol->mft_block,0,
		NTFS_MFT_RECORDSIZE,the_vol->mft,memcpy);
	/* fix it */
	if(!ntfs_check_mft_record(the_vol->mft)){
		fprintf(stderr,"MFT record not at cluster 0x%X\n",the_vol->mft_block);
		return 0;
	}
	if(!silent)
	fprintf(stderr,"MFT record at block 0x%X, offset 0x%X\n",the_vol->mft_block,
		the_vol->mft_block*NTFS_BLOCKSIZE);
	return 1;
}

int ntfs_read_mft_record(void *vol,int mftno,char *buf)
{
	ntfs_inode mft;
	mft.i_number=0;
	ntfs_get_inode(&mft);
	if(!ntfs_read_attr(vol,mft.attr,0,AT_DATA,NULL,
		mftno*NTFS_MFT_RECORDSIZE,
		buf,NTFS_MFT_RECORDSIZE,memcpy))return -1;
	if(!ntfs_check_mft_record(buf))
	{
		fprintf(stderr,"Inode not found\n");
		return -1;
	}
	return 0;
}

int ntfs_get_inode(ntfs_inode *ino)
{
	ntfs_inode mft;
	ino->attr=ntfs_allocate(NTFS_MFT_RECORDSIZE);
	if(ino->i_number==0)
	{
		memcpy(ino->attr,the_vol->mft,NTFS_MFT_RECORDSIZE);
		return 0;
	}
	return ntfs_read_mft_record(the_vol,ino->i_number,ino->attr);
}
