/*
 *  ntdir.c
 *
 *  Copyright (C) 1995 Martin von Lwis
 */

#include <stdio.h>
#include <getopt.h>
#include <unistd.h>
#include <string.h>
#include "ntfs.h"
#include "config.h"

char *short_opts="f:";
struct option options[]={
	{"filesystem",1,0,'f'}
};

void usage()
{
	fprintf(stderr,"ntdir [-f device] directory[/directory ...]\n");
}

/* display the directory ino */
void ntfs_print_dir(ntfs_inode* ino)
{
	long long fileno;
	int first;
	char item[1000];
	int namelen;
	for(fileno=0,first=1;1;)
	{
		/* get the next entry */
		if(!ntfs_getdir_byposition(the_vol,ino->attr,
			ino->i_number,&fileno,item))return;
		/* on the first iteration, we won't get any data */
		if(first){
			first=0;
			continue;
		}
		/* last access time? */
		print_time((long long*)(item+0x20));
		/* file size and mft record number */
		printf(" %10d %5d ",*(int*)(item+0x40),*(int*)item);
		namelen=*(unsigned char*)(item+0x50);
		/* file name */
		uniprint(item+0x52,namelen);
		putchar('\n');
	}
}

/* find file name in directory ino, return MFT record number if found */
int ntfs_find_file(ntfs_inode* ino,char *name)
{
	char item[1000];
	if(!ntfs_getdir_byname(the_vol,ino->attr,ino->i_number,
		name,strlen(name),item))
		return -1;
	return *(int*)item;
}

int main(int argc,char *argv[])
{
	int c;
	char *device=0;
	char *name;
	ntfs_inode ino;
	int inum;

	opterr=1;
	while((c=getopt_long(argc,argv,short_opts,options,NULL))>0)
	switch(c)
	{
		case 'f': device=optarg;break;
	}
	name=argv[optind];
	if(!ntfs_open_volume(device,1))return 1;
	/* walk the directory */
	inum=5;
	do{
		char *next;
		ino.i_number=inum;
		ntfs_get_inode(&ino);
		if(!name || !*name)break;
		next=strchr(name,'/');
		if(next){
			*next='\0';
			next++;
		}
		inum=ntfs_find_file(&ino,name);
		if(inum==-1){
			printf("%s not found",name);
			return 1;
		}
		name=next;
	}while(1);
	ntfs_print_dir(&ino);
}

