/*
 *  ntcat.c
 *
 *  Copyright (C) 1995 Martin von Lwis
 */

#include <stdio.h>
#include <getopt.h>
#include <unistd.h>
#include <string.h>
#include "ntfs.h"
#include "config.h"
/* glibc string.h does not define a memcpy prototype */
void* memcpy(void*,const void*,size_t);

char *short_opts="f:";
struct option options[]={
	{"filesystem",1,0,'f'}
};

void usage()
{
	fprintf(stderr,"ntcat [-f device] [directory/]filename\n");
}

/* print the file ino on stdout */
void ntfs_cat_file(ntfs_inode *ino)
{
	int position,len;
	char buf[NTFS_CLUSTERSIZE];
	position=0;
	/* read from the unnamed data attribute */
	while((len=ntfs_read_attr(the_vol,ino->attr,ino->i_number,AT_DATA,NULL,
		position,buf,NTFS_CLUSTERSIZE,memcpy))>0)
	{
		write(1,buf,len);
		position+=len;
	}
}

/* answer the MFT record number for file name in directory ino */
int ntfs_find_file(ntfs_inode* ino,char *name)
{
	char item[1000];
	if(!ntfs_getdir_byname(the_vol,ino->attr,ino->i_number,
		name,strlen(name),item))return -1;
	return *(int*)item;
}

int main(int argc,char *argv[])
{
	int c;
	char *device=0;
	char *name;
	ntfs_inode ino;
	int inum;

	opterr=1;
	while((c=getopt_long(argc,argv,short_opts,options,NULL))>0)
	switch(c)
	{
		case 'f': device=optarg;break;
	}
	name=argv[optind];
	if(!ntfs_open_volume(device,1))return 1;
	inum=5;
	/* walk the directory tree */
	do{
		char *next;
		ino.i_number=inum;
		ntfs_get_inode(&ino);
		if(!name || !*name)break;
		next=strchr(name,'/');
		if(next){
			*next='\0';
			next++;
		}
		inum=ntfs_find_file(&ino,name);
		if(inum==-1){
			printf("%s not found\n",name);
			return 1;
		}
		name=next;
	}while(1);
	ino.i_number=inum;
	ntfs_cat_file(&ino);
}

